/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.user.impl.ldap.repository;

import com.atlassian.user.impl.RepositoryException;
import com.atlassian.user.impl.ldap.InitialDirContextInitialisationHelper;
import com.atlassian.user.impl.ldap.properties.LdapConnectionProperties;
import com.atlassian.user.impl.ldap.repository.LdapConnectionFailedException;
import com.atlassian.user.impl.ldap.repository.LdapContextFactory;
import com.atlassian.user.util.UtilTimerStackUtils;
import com.google.common.annotations.VisibleForTesting;
import java.security.cert.CertificateException;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.function.Supplier;
import javax.naming.NamingException;
import javax.naming.directory.DirContext;
import javax.naming.directory.InitialDirContext;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class DefaultLdapContextFactory
implements LdapContextFactory {
    private static final Logger log = Logger.getLogger(DefaultLdapContextFactory.class);
    @VisibleForTesting
    protected static final String REFERRAL_STRATEGY_SYSTEM_PROPERTY = "atlassian.java.naming.referral";
    private final LdapConnectionProperties connectionProperties;

    public DefaultLdapContextFactory(LdapConnectionProperties connectionProperties) {
        this.connectionProperties = connectionProperties;
    }

    @Override
    public Hashtable<String, Object> getJNDIEnv() {
        String referral;
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("java.naming.provider.url", this.connectionProperties.getProviderURL());
        result.put("java.naming.factory.initial", this.connectionProperties.getJNDIInitialContextFactoryIdentifier());
        result.put("java.naming.security.authentication", this.connectionProperties.getSecurityAuthentication());
        result.put("java.naming.security.principal", this.connectionProperties.getSecurityPrincipal());
        result.put("java.naming.security.credentials", this.connectionProperties.getSecurityCredential());
        result.put("java.naming.security.protocol", this.connectionProperties.getSecurityProtocol());
        result.put("java.naming.batchsize", Integer.toString(this.connectionProperties.getSearchBatchSize()));
        result.put("com.sun.jndi.ldap.connect.timeout", Integer.toString(this.connectionProperties.getConnectTimeoutMillis()));
        result.put("com.sun.jndi.ldap.read.timeout", Integer.toString(this.connectionProperties.getReadTimeoutMillis()));
        this.checkAndEnableVerificationOfSslCertificateHostname(result);
        if (this.connectionProperties.isPoolingOn()) {
            result.put("com.sun.jndi.ldap.connect.pool", "true");
        }
        if ((referral = (String)ObjectUtils.defaultIfNull((Object)System.getProperty(REFERRAL_STRATEGY_SYSTEM_PROPERTY), (Object)this.connectionProperties.getReferralStrategy())) != null) {
            result.put("java.naming.referral", referral);
        }
        return this.createHashtable(result);
    }

    @Override
    public Hashtable getAuthenticationJndiEnvironment(String userDn, String password) {
        HashMap<String, Object> env = new HashMap<String, Object>(this.getJNDIEnv());
        env.put("java.naming.security.principal", userDn);
        env.put("java.naming.security.credentials", password);
        env.put("java.naming.security.authentication", "simple");
        this.checkAndEnableVerificationOfSslCertificateHostname(env);
        env.put("com.sun.jndi.ldap.connect.pool", "false");
        return this.createHashtable(env);
    }

    private <K, V> Hashtable<K, V> createHashtable(Map<K, V> map) {
        Hashtable<K, V> result = new Hashtable<K, V>();
        for (Map.Entry<K, V> entry : map.entrySet()) {
            if (entry.getValue() == null || entry.getKey() == null) continue;
            result.put(entry.getKey(), entry.getValue());
        }
        return result;
    }

    @Override
    public DirContext getLDAPContext() throws RepositoryException {
        Supplier<String> profilerMessageSupplier = () -> this.getClass().getName() + "_getLDAPContext";
        UtilTimerStackUtils.push(profilerMessageSupplier);
        try {
            InitialDirContext initialDirContext = InitialDirContextInitialisationHelper.newInitialDirContext(this.getClass().getClassLoader(), this.getJNDIEnv());
            return initialDirContext;
        }
        catch (NamingException e) {
            if (this.isHasRootInChain(e, CertificateException.class)) {
                log.error((Object)"Host verification in the LDAP certificate failed. Check whether the hostname in the LDAP connection settings matches the hostname in the server certificate. To disable the validation, set the verifySslCertificateHostname property to 'false' in atlassian-users.xml.");
            }
            throw new LdapConnectionFailedException(e);
        }
        finally {
            UtilTimerStackUtils.pop(profilerMessageSupplier);
        }
    }

    private boolean isHasRootInChain(Throwable e, Class<? extends Exception> rootCause) {
        Throwable root = e.getCause();
        if (root != null && root != e) {
            if (root.getClass().equals(rootCause)) {
                return true;
            }
            return this.isHasRootInChain(root, rootCause);
        }
        return false;
    }

    private void checkAndEnableVerificationOfSslCertificateHostname(Map<String, Object> env) {
        if (this.connectionProperties.isVerifySslCertificateHostname() && StringUtils.contains((String)this.connectionProperties.getSecurityProtocol(), (String)"ssl")) {
            env.put("java.naming.ldap.factory.socket", "com.atlassian.user.util.LdapHostnameVerificationSSLSocketFactory");
        }
    }
}

