/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.user.impl.ldap.adaptor;

import com.atlassian.user.EntityException;
import com.atlassian.user.Group;
import com.atlassian.user.User;
import com.atlassian.user.impl.RepositoryException;
import com.atlassian.user.impl.ldap.LDAPEntity;
import com.atlassian.user.impl.ldap.LDAPGroupFactory;
import com.atlassian.user.impl.ldap.adaptor.AbstractLDAPGroupAdaptor;
import com.atlassian.user.impl.ldap.properties.LdapMembershipProperties;
import com.atlassian.user.impl.ldap.properties.LdapSearchProperties;
import com.atlassian.user.impl.ldap.repository.LdapContextFactory;
import com.atlassian.user.impl.ldap.search.DefaultLDAPUserAdaptor;
import com.atlassian.user.impl.ldap.search.LDAPPagerInfo;
import com.atlassian.user.impl.ldap.search.LDAPUserAdaptor;
import com.atlassian.user.impl.ldap.search.LdapFilterFactory;
import com.atlassian.user.impl.ldap.search.page.LDAPEntityPager;
import com.atlassian.user.impl.ldap.search.page.LDAPMembershipToUsernamePager;
import com.atlassian.user.search.page.DefaultPager;
import com.atlassian.user.search.page.Pager;
import com.atlassian.user.util.LDAPUtils;
import com.atlassian.user.util.UtilTimerStackUtils;
import java.util.function.Supplier;
import org.springframework.ldap.filter.EqualsFilter;
import org.springframework.ldap.filter.Filter;

public class LDAPStaticGroupAdaptor
extends AbstractLDAPGroupAdaptor {
    private final LDAPUserAdaptor userAdaptor;
    private final LdapMembershipProperties membershipProperties;

    public LDAPStaticGroupAdaptor(LdapContextFactory repository, LdapSearchProperties searchProperties, LDAPGroupFactory groupFactory, LdapFilterFactory filterFactory, LdapMembershipProperties membershipProperties) {
        super(repository, searchProperties, groupFactory, filterFactory);
        this.membershipProperties = membershipProperties;
        this.userAdaptor = new DefaultLDAPUserAdaptor(repository, searchProperties, filterFactory);
    }

    @Override
    public Pager<Group> getGroups(User user) throws EntityException {
        LDAPPagerInfo info = this.getGroupEntriesViaMembership(user);
        if (info == null) {
            return DefaultPager.emptyPager();
        }
        return new LDAPEntityPager<Group>(this.searchProperties, this.repository, this.groupFactory, info);
    }

    @Override
    public Pager<String> findMembers(Group group) throws EntityException {
        LDAPPagerInfo info = this.getGroupEntries(group.getName(), new String[]{this.membershipProperties.getMembershipAttribute()}, null);
        return new LDAPMembershipToUsernamePager(this.searchProperties, this.repository, info);
    }

    @Override
    public Pager<String> findMemberNames(Group group) throws EntityException {
        LDAPPagerInfo info = this.getGroupEntries(group.getName(), new String[]{this.membershipProperties.getMembershipAttribute()}, null);
        return new LDAPMembershipToUsernamePager(this.searchProperties, this.repository, info);
    }

    @Override
    public boolean hasStaticGroups() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasMembership(Group group, User user) throws RepositoryException {
        if (!(user instanceof LDAPEntity)) {
            return false;
        }
        Supplier<String> profilerMessageSupplier = () -> this.getClass().getName() + "_hasMembership(" + group + ", " + user + ")";
        UtilTimerStackUtils.push(profilerMessageSupplier);
        try {
            Filter searchFilter = LDAPUtils.makeAndFilter((Filter)new EqualsFilter(this.searchProperties.getGroupnameAttribute(), group.getName()), (Filter)new EqualsFilter(this.membershipProperties.getMembershipAttribute(), this.getNameForMembershipComparison(user)));
            String[] attributesToReturn = new String[]{this.searchProperties.getGroupnameAttribute()};
            LDAPPagerInfo result = this.search(searchFilter, attributesToReturn);
            boolean bl = result.getNamingEnumeration().hasMoreElements();
            return bl;
        }
        finally {
            UtilTimerStackUtils.pop(profilerMessageSupplier);
        }
    }

    private String getNameForMembershipComparison(User user) {
        return this.membershipProperties.isMembershipAttributeUnqualified() ? user.getName() : ((LDAPEntity)user).getDistinguishedName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public LDAPPagerInfo getGroupEntriesViaMembership(User user) throws EntityException {
        if (!(user instanceof LDAPEntity)) {
            this.log.info((Object)("Membership check for a non " + LDAPEntity.class.getName()));
            return this.getGroupEntriesViaMembership(user.getName());
        }
        Supplier<String> profilerMessageSupplier = () -> this.getClass().getName() + "_getLDAPGroupEntriesViaLDAPUser(" + user.getName() + ")";
        UtilTimerStackUtils.push(profilerMessageSupplier);
        try {
            String[] attributesToReturn = new String[]{this.searchProperties.getGroupnameAttribute()};
            EqualsFilter searchTerm = new EqualsFilter(this.membershipProperties.getMembershipAttribute(), this.getNameForMembershipComparison(user));
            LDAPPagerInfo lDAPPagerInfo = this.getGroupEntries(attributesToReturn, (Filter)searchTerm);
            return lDAPPagerInfo;
        }
        finally {
            UtilTimerStackUtils.pop(profilerMessageSupplier);
        }
    }

    @Override
    public LDAPPagerInfo getGroupEntriesViaMembership(String username) throws EntityException {
        return this.getGroupEntriesViaMembership(username, null);
    }

    @Override
    public LDAPPagerInfo getGroupEntriesViaMembership(String username, String[] attributesToReturn) throws EntityException {
        Supplier<String> profilerMessageSupplier = () -> this.getClass().getName() + "_getLDAPGroupEntriesViaMembership(" + username + ")";
        UtilTimerStackUtils.push(profilerMessageSupplier);
        try {
            if (attributesToReturn == null) {
                attributesToReturn = new String[]{this.searchProperties.getGroupnameAttribute()};
            }
            String name = this.membershipProperties.isMembershipAttributeUnqualified() ? username : this.userAdaptor.getUserDN(username);
            EqualsFilter searchTerm = new EqualsFilter(this.membershipProperties.getMembershipAttribute(), name);
            LDAPPagerInfo lDAPPagerInfo = this.getGroupEntries(attributesToReturn, (Filter)searchTerm);
            return lDAPPagerInfo;
        }
        catch (RepositoryException e) {
            throw new RepositoryException((Throwable)e);
        }
        finally {
            UtilTimerStackUtils.pop(profilerMessageSupplier);
        }
    }
}

