/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.user.impl.ldap;

import com.atlassian.user.Entity;
import com.atlassian.user.EntityException;
import com.atlassian.user.User;
import com.atlassian.user.impl.ReadOnlyUserManager;
import com.atlassian.user.impl.ldap.DefaultLDAPUserFactory;
import com.atlassian.user.impl.ldap.LDAPValidator;
import com.atlassian.user.impl.ldap.properties.LdapSearchProperties;
import com.atlassian.user.impl.ldap.repository.LdapContextFactory;
import com.atlassian.user.impl.ldap.search.DefaultLDAPUserAdaptor;
import com.atlassian.user.impl.ldap.search.LDAPPagerInfo;
import com.atlassian.user.impl.ldap.search.LDAPUserAdaptor;
import com.atlassian.user.impl.ldap.search.LdapFilterFactory;
import com.atlassian.user.impl.ldap.search.page.LDAPEntityPager;
import com.atlassian.user.impl.ldap.search.page.LDAPSingleStringPager;
import com.atlassian.user.repository.RepositoryIdentifier;
import com.atlassian.user.search.page.Pager;
import com.atlassian.user.util.UtilTimerStackUtils;
import java.net.Inet4Address;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import java.util.function.Supplier;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.ldap.filter.EqualsFilter;
import org.springframework.ldap.filter.Filter;

public class LDAPUserManagerReadOnly
extends ReadOnlyUserManager {
    protected final Logger log = Logger.getLogger(((Object)((Object)this)).getClass());
    private final RepositoryIdentifier repositoryIdentifier;
    private final LdapContextFactory repository;
    private final LdapSearchProperties searchProperties;
    private final LDAPUserAdaptor userAdaptor;

    public LDAPUserManagerReadOnly(RepositoryIdentifier repositoryIdentifier, LdapContextFactory repository, LdapSearchProperties searchProperties, LdapFilterFactory filterFactory) {
        this.repositoryIdentifier = repositoryIdentifier;
        this.repository = repository;
        this.searchProperties = searchProperties;
        this.userAdaptor = new DefaultLDAPUserAdaptor(repository, searchProperties, filterFactory);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Pager<User> getUsers() throws EntityException {
        Supplier<String> profilerMessageSupplier = () -> ((Object)((Object)this)).getClass().getName() + "_getUsers";
        UtilTimerStackUtils.push(profilerMessageSupplier);
        try {
            LDAPPagerInfo info = this.userAdaptor.search(null);
            LDAPEntityPager<User> lDAPEntityPager = new LDAPEntityPager<User>(this.searchProperties, this.repository, new DefaultLDAPUserFactory(this.searchProperties), info);
            return lDAPEntityPager;
        }
        finally {
            UtilTimerStackUtils.pop(profilerMessageSupplier);
        }
    }

    public Pager<String> getUserNames() throws EntityException {
        LDAPPagerInfo info = this.userAdaptor.search(null, new String[]{this.searchProperties.getUsernameAttribute()});
        return new LDAPSingleStringPager(this.searchProperties, this.repository, info);
    }

    @Nullable
    public User getUser(@NotNull String username) throws EntityException {
        Supplier<String> profilerMessageSupplier = () -> ((Object)((Object)this)).getClass().getName() + "_getUser(" + username + ")";
        UtilTimerStackUtils.push(profilerMessageSupplier);
        try {
            LDAPPagerInfo info = this.userAdaptor.search((Filter)new EqualsFilter(this.searchProperties.getUsernameAttribute(), username));
            LDAPEntityPager<User> pager = new LDAPEntityPager<User>(this.searchProperties, this.repository, new DefaultLDAPUserFactory(this.searchProperties), info);
            if (!pager.isEmpty()) {
                User user = (User)pager.iterator().next();
                return user;
            }
        }
        catch (EntityException e) {
            String host = "<unknown>";
            String ipAddress = "<unknown>";
            try {
                String urlString = (String)this.repository.getJNDIEnv().get("java.naming.provider.url");
                URI uri = new URI(urlString);
                host = uri.getHost();
                ipAddress = Inet4Address.getByName(host).getHostAddress();
            }
            catch (URISyntaxException | UnknownHostException use) {
                this.log.debug((Object)"Error while retrieving LDAP server info", (Throwable)use);
            }
            throw new EntityException("Error retrieving user: '" + username + "' from LDAP server " + host + "[" + ipAddress + "]", (Throwable)e);
        }
        finally {
            UtilTimerStackUtils.pop(profilerMessageSupplier);
        }
        return null;
    }

    public RepositoryIdentifier getIdentifier() {
        return this.repositoryIdentifier;
    }

    public RepositoryIdentifier getRepository(@NotNull Entity entity) throws EntityException {
        if (!LDAPValidator.validateLDAPEntity(entity)) {
            return null;
        }
        if (this.getUser(entity.getName()) == null) {
            return null;
        }
        return this.repositoryIdentifier;
    }
}

