/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.user.impl.ldap;

import com.atlassian.user.User;
import com.atlassian.user.impl.RepositoryException;
import com.atlassian.user.impl.ldap.DefaultLDAPUser;
import com.atlassian.user.impl.ldap.LDAPUserFactory;
import com.atlassian.user.impl.ldap.properties.LdapSearchProperties;
import com.atlassian.user.util.UtilTimerStackUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.function.Supplier;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.SearchResult;

public class DefaultLDAPUserFactory
implements LDAPUserFactory {
    private final LdapSearchProperties searchProperties;

    public DefaultLDAPUserFactory(LdapSearchProperties searchProperties) {
        this.searchProperties = searchProperties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DefaultLDAPUser getUser(Attributes attrs, String distinguishedName) throws RepositoryException {
        DefaultLDAPUser defaultLDAPUser;
        Attribute uidAttr = attrs.get(this.searchProperties.getUsernameAttribute());
        if (uidAttr == null) {
            return null;
        }
        if (!distinguishedName.contains(this.searchProperties.getBaseUserNamespace())) {
            distinguishedName = distinguishedName + "," + this.searchProperties.getBaseUserNamespace();
        }
        DefaultLDAPUser user = new DefaultLDAPUser((String)uidAttr.get(), distinguishedName);
        Supplier<String> profilerMessageSupplier = () -> this.getClass().getName() + "_getUser(" + user.getName() + ")";
        UtilTimerStackUtils.push(profilerMessageSupplier);
        try {
            Attribute emailAttr;
            Attribute givenNameAttr = attrs.get(this.searchProperties.getFirstnameAttribute());
            Attribute surNameAttr = attrs.get(this.searchProperties.getSurnameAttribute());
            if (givenNameAttr != null) {
                String givenName = (String)givenNameAttr.get();
                String surName = "";
                if (surNameAttr != null) {
                    surName = (String)surNameAttr.get();
                }
                givenName = givenName.concat(" ");
                user.setFullName(givenName.concat(surName));
            }
            if ((emailAttr = attrs.get(this.searchProperties.getEmailAttribute())) != null) {
                user.setEmail((String)emailAttr.get());
            }
            defaultLDAPUser = user;
        }
        catch (Throwable throwable) {
            try {
                UtilTimerStackUtils.pop(profilerMessageSupplier);
                throw throwable;
            }
            catch (NamingException e) {
                throw new RepositoryException((Throwable)e);
            }
        }
        UtilTimerStackUtils.pop(profilerMessageSupplier);
        return defaultLDAPUser;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<User> getUsers(Enumeration userNamingEnumeration) throws RepositoryException {
        Supplier<String> profilerMessageSupplier = () -> this.getClass().getName() + "_getUserCollection";
        UtilTimerStackUtils.push(profilerMessageSupplier);
        try {
            ArrayList<User> users = new ArrayList<User>();
            while (userNamingEnumeration.hasMoreElements()) {
                SearchResult result = (SearchResult)userNamingEnumeration.nextElement();
                Attributes attrs = result.getAttributes();
                users.add((User)this.getUser(attrs, result.getName()));
            }
            ArrayList<User> arrayList = users;
            return arrayList;
        }
        finally {
            UtilTimerStackUtils.pop(profilerMessageSupplier);
        }
    }

    @Override
    public DefaultLDAPUser getEntity(Attributes attrs, String distinguishedName) throws RepositoryException {
        if (distinguishedName.startsWith("\"") && distinguishedName.endsWith("\"")) {
            distinguishedName = distinguishedName.substring(1, distinguishedName.length() - 1);
        }
        return this.getUser(attrs, distinguishedName);
    }
}

