/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.user.impl.ldap;

import com.atlassian.user.EntityException;
import com.atlassian.user.impl.RepositoryException;
import com.atlassian.user.impl.ldap.DefaultLDAPGroup;
import com.atlassian.user.impl.ldap.LDAPGroupFactory;
import com.atlassian.user.impl.ldap.properties.LdapMembershipProperties;
import com.atlassian.user.impl.ldap.properties.LdapSearchProperties;
import com.atlassian.user.util.UtilTimerStackUtils;
import java.util.function.Supplier;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DefaultLDAPGroupFactory
implements LDAPGroupFactory {
    private final LdapSearchProperties searchProperties;
    private final LdapMembershipProperties membershipProperties;

    public DefaultLDAPGroupFactory(LdapSearchProperties searchProperties, LdapMembershipProperties membershipProperties) {
        this.membershipProperties = membershipProperties;
        this.searchProperties = searchProperties;
    }

    public DefaultLDAPGroup getGroup(Attributes attrs, String distinguishedName) throws EntityException {
        Supplier<String> profilerMessageSupplier = () -> this.getClass().getName() + "_delegating_getGroup(attrs, " + distinguishedName + ")";
        UtilTimerStackUtils.push(profilerMessageSupplier);
        try {
            Attribute groupNameAttribute = attrs.get(this.searchProperties.getGroupnameAttribute());
            if (groupNameAttribute != null) {
                String groupName = (String)groupNameAttribute.get();
                DefaultLDAPGroup defaultLDAPGroup = new DefaultLDAPGroup(groupName, distinguishedName);
                return defaultLDAPGroup;
            }
            Attribute membershipAttribute = attrs.get(this.membershipProperties.getMembershipAttribute());
            DefaultLDAPGroup defaultLDAPGroup = this.getGroup(membershipAttribute);
            return defaultLDAPGroup;
        }
        catch (NamingException e) {
            throw new RepositoryException((Throwable)e);
        }
        finally {
            UtilTimerStackUtils.pop(profilerMessageSupplier);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DefaultLDAPGroup getGroup(String distinguishedName) {
        Supplier<String> profilerMessageSupplier = () -> this.getClass().getName() + "_delegating_getGroup(" + distinguishedName + ")";
        UtilTimerStackUtils.push(profilerMessageSupplier);
        try {
            String groupName = this.getGroupNameFromDN(distinguishedName);
            DefaultLDAPGroup defaultLDAPGroup = new DefaultLDAPGroup(groupName, distinguishedName);
            return defaultLDAPGroup;
        }
        finally {
            UtilTimerStackUtils.pop(profilerMessageSupplier);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DefaultLDAPGroup getGroup(Attribute attribute) throws EntityException {
        Supplier<String> profilerMessageSupplier = () -> this.getClass().getName() + "_delegating_getGroup(attr)";
        UtilTimerStackUtils.push(profilerMessageSupplier);
        try {
            String groupDN = this.getGroupDNFromMembershipAttribute(attribute);
            if (groupDN == null) {
                throw new EntityException("Unable to extract group's DN from attribute");
            }
            String groupName = this.getGroupNameFromDN(groupDN);
            DefaultLDAPGroup defaultLDAPGroup = new DefaultLDAPGroup(groupName, groupDN);
            return defaultLDAPGroup;
        }
        finally {
            UtilTimerStackUtils.pop(profilerMessageSupplier);
        }
    }

    @Nullable
    private String getGroupDNFromMembershipAttribute(Attribute groupMembershipAtt) throws EntityException {
        Supplier<String> profilerMessageSupplier = () -> this.getClass().getName() + "_delegating_getGroupDNFromMembershipAttribute";
        UtilTimerStackUtils.push(profilerMessageSupplier);
        try {
            NamingEnumeration<?> groupAttrs = groupMembershipAtt.getAll();
            while (groupAttrs.hasMoreElements()) {
                String groupDN = (String)groupAttrs.nextElement();
                if (groupDN == null) continue;
                String string = groupDN;
                return string;
            }
        }
        catch (NamingException e) {
            throw new RepositoryException((Throwable)e);
        }
        finally {
            UtilTimerStackUtils.pop(profilerMessageSupplier);
        }
        return null;
    }

    private String getGroupNameFromDN(@NotNull String groupDN) {
        if (!groupDN.contains("=")) {
            return groupDN;
        }
        String[] names = groupDN.split(",");
        return names[0].split("=")[1];
    }

    @Override
    public DefaultLDAPGroup getEntity(Attributes attrs, String distinguishedName) throws EntityException {
        return this.getGroup(attrs, distinguishedName);
    }

    public DefaultLDAPGroup getEntity(Attribute attr, String distinguishedName) throws EntityException {
        return this.getGroup(attr);
    }
}

