/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.user.impl.delegation.properties;

import com.atlassian.user.Entity;
import com.atlassian.user.EntityException;
import com.atlassian.user.properties.PropertySetFactory;
import com.atlassian.user.util.UtilTimerStackUtils;
import com.opensymphony.module.propertyset.PropertySet;
import java.util.Collections;
import java.util.List;
import java.util.function.Supplier;

public class DelegatingPropertySetFactory
implements PropertySetFactory {
    private final List<PropertySetFactory> propertySetFactories;

    public DelegatingPropertySetFactory(List<PropertySetFactory> propertySetFactories) {
        this.propertySetFactories = propertySetFactories;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PropertySet getPropertySet(Entity entity) throws EntityException {
        Supplier<String> profilerMessageSupplier = () -> this.getClass().getName() + "_delegating_getPropertySet(" + entity.getName() + ")";
        UtilTimerStackUtils.push(profilerMessageSupplier);
        try {
            for (PropertySetFactory propertySetFactory : this.propertySetFactories) {
                PropertySet propertySet = propertySetFactory.getPropertySet(entity);
                if (propertySet == null) continue;
                PropertySet propertySet2 = propertySet;
                return propertySet2;
            }
        }
        finally {
            UtilTimerStackUtils.pop(profilerMessageSupplier);
        }
        return null;
    }

    public List<PropertySetFactory> getPropertySetFactories() {
        return Collections.unmodifiableList(this.propertySetFactories);
    }
}

