/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.upm.license;

import com.atlassian.upm.api.license.entity.LicenseError;
import com.atlassian.upm.api.license.entity.LicenseType;
import com.atlassian.upm.api.license.entity.PluginLicense;
import com.atlassian.upm.api.util.Option;
import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableSet;
import java.util.Iterator;
import org.joda.time.DateTime;
import org.joda.time.Days;
import org.joda.time.Interval;
import org.joda.time.ReadableInstant;

public class PluginLicenses {
    public static final Integer NEARLY_EXPIRED_DAYS = 7;
    public static final Integer RECENTLY_EXPIRED_DAYS = 7;
    private static final Function<PluginLicense, String> licensePluginKey = new Function<PluginLicense, String>(){

        public String apply(PluginLicense from) {
            return from.getPluginKey();
        }
    };
    private static final Function<PluginLicense, DateTime> licenseCreationDate = new Function<PluginLicense, DateTime>(){

        public DateTime apply(PluginLicense from) {
            return from.getCreationDate();
        }
    };

    public static Predicate<PluginLicense> hasError(final LicenseError error) {
        return new Predicate<PluginLicense>(){

            public boolean apply(PluginLicense license) {
                return error == license.getError().getOrElse((Object)null);
            }
        };
    }

    public static Predicate<PluginLicense> isNearlyExpired() {
        return new Predicate<PluginLicense>(){

            public boolean apply(PluginLicense license) {
                Iterator i$ = license.getExpiryDate().iterator();
                if (i$.hasNext()) {
                    DateTime expiryDate = (DateTime)i$.next();
                    return new Interval((ReadableInstant)expiryDate.minusDays(NEARLY_EXPIRED_DAYS.intValue()), (ReadableInstant)expiryDate).contains((ReadableInstant)new DateTime());
                }
                return false;
            }
        };
    }

    public static Predicate<PluginLicense> isNearlyMaintenanceExpired() {
        return new Predicate<PluginLicense>(){

            public boolean apply(PluginLicense license) {
                Iterator i$ = license.getMaintenanceExpiryDate().iterator();
                if (i$.hasNext()) {
                    DateTime maintenanceExpiryDate = (DateTime)i$.next();
                    return new Interval((ReadableInstant)maintenanceExpiryDate.minusDays(NEARLY_EXPIRED_DAYS.intValue()), (ReadableInstant)maintenanceExpiryDate).contains((ReadableInstant)new DateTime());
                }
                return false;
            }
        };
    }

    public static Predicate<PluginLicense> isRecentlyExpired() {
        return new IsRecentlyExpired();
    }

    public static Predicate<PluginLicense> isRecentlyMaintenanceExpired() {
        return new IsRecentlyMaintenanceExpired();
    }

    public static Predicate<PluginLicense> isEvaluation() {
        return new Predicate<PluginLicense>(){

            public boolean apply(PluginLicense license) {
                return license.isEvaluation();
            }
        };
    }

    public static Option<Days> getDaysSinceMaintenanceExpiry(PluginLicense pluginLicense) {
        Iterator i$ = pluginLicense.getMaintenanceExpiryDate().iterator();
        if (i$.hasNext()) {
            DateTime maintenanceExpiryDate = (DateTime)i$.next();
            if (!pluginLicense.isMaintenanceExpired()) {
                return Option.none(Days.class);
            }
            return Option.some((Object)Days.daysBetween((ReadableInstant)maintenanceExpiryDate, (ReadableInstant)new DateTime()));
        }
        return Option.none(Days.class);
    }

    public static boolean isPluginBuyable(Option<PluginLicense> pluginLicense) {
        Iterator i$ = pluginLicense.iterator();
        if (i$.hasNext()) {
            PluginLicense registeredLicense = (PluginLicense)i$.next();
            return registeredLicense.isEvaluation() || PluginLicenses.isErrorEqual((Option<LicenseError>)registeredLicense.getError(), LicenseError.TYPE_MISMATCH);
        }
        return true;
    }

    public static boolean isPluginTryable(Option<PluginLicense> pluginLicense) {
        return !pluginLicense.isDefined();
    }

    public static boolean isPluginRenewable(Option<PluginLicense> pluginLicense) {
        if (PluginLicenses.isPluginUpgradable(pluginLicense)) {
            return false;
        }
        Iterator i$ = pluginLicense.iterator();
        if (i$.hasNext()) {
            PluginLicense registeredLicense = (PluginLicense)i$.next();
            boolean nearlyExpired = PluginLicenses.isNearlyExpired().apply((Object)registeredLicense);
            boolean nearlyMaintenanceExpired = PluginLicenses.isNearlyMaintenanceExpired().apply((Object)registeredLicense);
            boolean maintenanceExpired = registeredLicense.isMaintenanceExpired();
            boolean hasAppropriateError = registeredLicense.getError().isDefined() && ImmutableSet.of((Object[])new LicenseError[]{LicenseError.EXPIRED, LicenseError.VERSION_MISMATCH}).contains(registeredLicense.getError().get());
            boolean hasAppropriateType = ImmutableSet.of((Object[])new LicenseType[]{LicenseType.ACADEMIC, LicenseType.COMMERCIAL, LicenseType.STARTER}).contains((Object)registeredLicense.getLicenseType());
            boolean evaluation = registeredLicense.isEvaluation();
            return (nearlyExpired || nearlyMaintenanceExpired || maintenanceExpired || hasAppropriateError) && hasAppropriateType && !evaluation;
        }
        return false;
    }

    public static boolean isPluginUpgradable(Option<PluginLicense> pluginLicense) {
        if (PluginLicenses.isPluginBuyable(pluginLicense)) {
            return false;
        }
        Iterator i$ = pluginLicense.iterator();
        if (i$.hasNext()) {
            PluginLicense registeredLicense = (PluginLicense)i$.next();
            return PluginLicenses.isErrorEqual((Option<LicenseError>)registeredLicense.getError(), LicenseError.USER_MISMATCH) || PluginLicenses.isErrorEqual((Option<LicenseError>)registeredLicense.getError(), LicenseError.EDITION_MISMATCH);
        }
        return false;
    }

    public static Function<PluginLicense, String> licensePluginKey() {
        return licensePluginKey;
    }

    public static Function<PluginLicense, DateTime> licenseCreationDate() {
        return licenseCreationDate;
    }

    private static boolean isErrorEqual(Option<LicenseError> possibleError, LicenseError equalTo) {
        Iterator i$ = possibleError.iterator();
        if (i$.hasNext()) {
            LicenseError error = (LicenseError)i$.next();
            return equalTo.equals((Object)error);
        }
        return false;
    }

    private static class IsRecentlyMaintenanceExpired
    implements Predicate<PluginLicense> {
        private final DateTime sevenDaysAgo = new DateTime().minusDays(RECENTLY_EXPIRED_DAYS.intValue());

        public boolean apply(PluginLicense license) {
            Iterator i$ = license.getMaintenanceExpiryDate().iterator();
            if (i$.hasNext()) {
                DateTime maintenanceExpiryDate = (DateTime)i$.next();
                return maintenanceExpiryDate.isAfter((ReadableInstant)this.sevenDaysAgo) && maintenanceExpiryDate.isBefore((ReadableInstant)new DateTime());
            }
            return false;
        }
    }

    private static class IsRecentlyExpired
    implements Predicate<PluginLicense> {
        private final DateTime sevenDaysAgo = new DateTime().minusDays(RECENTLY_EXPIRED_DAYS.intValue());

        public boolean apply(PluginLicense license) {
            Iterator i$ = license.getExpiryDate().iterator();
            if (i$.hasNext()) {
                DateTime expiryDate = (DateTime)i$.next();
                return expiryDate.isAfter((ReadableInstant)this.sevenDaysAgo) && expiryDate.isBefore((ReadableInstant)new DateTime());
            }
            return false;
        }
    }
}

