package com.atlassian.upm.impl;

import org.apache.commons.codec.digest.DigestUtils;

/**
 * Takes care of situation where plugin settings keys are too long.
 */
public class LongKeyHasher
{
    private static final Integer MAX_KEY_LENGTH = 100;
    
    /**
     * Confluence limits plugin settings keys to being 100 characters long. That won't work for this implementation.
     * Let's hash the plugin keys if need be.
     */
    public static String hashKeyIfTooLong(final String key)
    {
        if (key.length() > MAX_KEY_LENGTH)
        {
            final String keyHash = DigestUtils.md5Hex(key);
            final String keptOriginalKey = key.substring(0, MAX_KEY_LENGTH - keyHash.length());
            final String hashedKey = keptOriginalKey + keyHash;
            return hashedKey;
        }
        return key;
    }
}
