package com.atlassian.upm;

import com.atlassian.upm.api.util.Option;

import com.google.common.collect.ImmutableList;

import static java.lang.Boolean.getBoolean;
import static org.apache.commons.lang.StringUtils.isBlank;

/**
 * Copied in part from {@link com.atlassian.upm.Sys} because this is used in the compatibility SPI
 * which cannot depend on the new version of UPM which would contain the required method.
 */
public abstract class SysCommon
{
    public static final String UPM_ON_DEMAND = "atlassian.upm.on.demand";
    public static final String UPM_OD_PVA_BLACKLIST = "atlassian.upm.on.demand.pva.blacklist";
    private static final String DEFAULT_BLACKLIST_VALUE = "jira-timesheet-plugin,"
                                                          + "com.balsamiq.jira.plugins.mockups,"
                                                          + "com.balsamiq.confluence.plugins.mockups,"
                                                          + "org.swift.confluence.table";

    public static boolean isOnDemand()
    {
        return getBoolean(UPM_ON_DEMAND);
    }

    /**
     * UPM-3696 OnDemand wants to be able to update the PvA blacklist via sysprop (decoupling it from a UPM version update)
     */
    public static Iterable<String> getOnDemandPaidViaAtlassianBlacklist()
    {
        return getPluginKeysFromSysProp(UPM_OD_PVA_BLACKLIST, Option.some(DEFAULT_BLACKLIST_VALUE));
    }

    public static Iterable<String> getPluginKeysFromSysProp(String propKey, Option<String> defaultValue)
    {
        String pluginKeys = defaultValue.isDefined() ? System.getProperty(propKey, defaultValue.get()) : System.getProperty(propKey);
        if (!isOnDemand() || isBlank(pluginKeys))
        {
            return ImmutableList.of();
        }

        return ImmutableList.of(pluginKeys.trim().split(","));
    }
}
