UPM.define('AvailableApplicationCollectionItemView', [
    'BaseCollectionItemView',
    'UpmAnalytics'
], function(BaseCollectionItemView,
            UpmAnalytics) {

    'use strict';

    return BaseCollectionItemView.extend({

        events: {
            'click button.try': '_triggerTryAvailableApp',
            'click a.learn-more': '_handleLearnMoreLink'
        },

        template: com.atlassian.upm.application.availableApp,

        _getData: function () {
            return { app: this.model.toJSON() };
        },

        _handleLearnMoreLink: function () {
            UpmAnalytics.logEvent('manageapps-available-app-learn-more', { appKey: this.model.getKey() });
        },

        _triggerTryAvailableApp: function (e) {
            e.preventDefault();
            this.model.trigger('tryAvailableApp', this.model);
            UpmAnalytics.logEvent('manageapps-available-app-try', { appKey: this.model.getKey() });
        }

    });
});
