UPM.define("ApplicationCollectionView", [
    'BaseCollectionView',
    'ApplicationCollectionItemView',
    'EmptyApplicationCollectionView'
], function(BaseCollectionView,
            ApplicationCollectionItemView,
            EmptyApplicationCollectionView) {


    'use strict';


    return BaseCollectionView.extend({

        itemView: ApplicationCollectionItemView,

        emptyView: EmptyApplicationCollectionView,

        _initEvents: function() {
            this.listenTo(this.collection, 'add', this.render);
            this.listenTo(this.collection, 'remove', this.render);
            BaseCollectionView.prototype._initEvents.apply(this);
        },

        _postInitialize: function() {
            var list = this.$el;
            this.collection.map(function(model) {
                return new ApplicationCollectionItemView({
                    model: model,
                    el: list.find('.application-item[data-application-key="' + model.getKey() + '"]')
                });
            });
        }
    });
});
