/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.upm.impl;

import com.atlassian.upm.api.util.Option;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.Date;
import java.util.Optional;
import javax.annotation.Nullable;
import org.joda.time.DateTime;
import org.joda.time.Duration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DateUtil {
    private static final Logger log = LoggerFactory.getLogger(DateUtil.class);

    private DateUtil() {
    }

    public static ZonedDateTime toZonedDate(DateTime dt) {
        if (dt == null) {
            return null;
        }
        return dt.toGregorianCalendar().toZonedDateTime();
    }

    public static Optional<ZonedDateTime> toOptionalZonedDate(Option<DateTime> jodaDate) {
        return jodaDate.fold(Optional::empty, d -> Optional.of(DateUtil.toZonedDate(d)));
    }

    @Deprecated
    public static DateTime toDateTime(ZonedDateTime dt) {
        if (dt == null) {
            return null;
        }
        long millis = dt.toInstant().toEpochMilli();
        return new DateTime(millis);
    }

    public static java.time.Duration convertToJavaDuration(@Nullable Duration jodaDuration) {
        if (jodaDuration == null) {
            return null;
        }
        return java.time.Duration.ofMillis(jodaDuration.getMillis());
    }

    public static <T> Optional<T> toOptional(Option<T> option) {
        if (option.isDefined()) {
            return Optional.of(option.get());
        }
        return Optional.empty();
    }

    @Deprecated
    public static <T> Option<T> toOption(Optional<T> optional) {
        if (optional.isPresent()) {
            return Option.some(optional.get());
        }
        return Option.none();
    }

    @Deprecated
    public static Option<DateTime> toOptionDateTime(Optional<ZonedDateTime> javaDate) {
        return javaDate.map(zdt -> zdt.toInstant().toEpochMilli()).map(DateTime::new).map(Option::option).orElse(Option.none());
    }

    public static Optional<java.time.Duration> toOptionalDuration(Option<Duration> optionDuration) {
        return optionDuration.fold(Optional::empty, d -> Optional.of(java.time.Duration.ofMillis(d.getMillis())));
    }

    public static ZonedDateTime dateToZonedDateTime(Date date) {
        if (date == null) {
            return null;
        }
        return date.toInstant().atZone(ZoneId.systemDefault());
    }

    public static ZonedDateTime parseZonedDatetime(String dateString, DateTimeFormatter dateTimeFormatter) {
        ZonedDateTime parsedDateTime = DateUtil.tryParseZonedDateTime(dateString, dateTimeFormatter);
        if (parsedDateTime == null) {
            parsedDateTime = DateUtil.tryParseLocalDateTime(dateString, dateTimeFormatter);
        }
        if (parsedDateTime == null) {
            parsedDateTime = DateUtil.tryParseLocalDate(dateString, dateTimeFormatter);
        }
        if (parsedDateTime == null) {
            log.warn("Invalid Date of \"" + dateString + "\"");
        }
        return parsedDateTime;
    }

    private static ZonedDateTime tryParseZonedDateTime(String dateString, DateTimeFormatter dateTimeFormatter) {
        try {
            return ZonedDateTime.parse(dateString, dateTimeFormatter);
        }
        catch (IllegalArgumentException | DateTimeParseException e) {
            log.warn("Invalid Date parsing as ZonedDateTime \"" + dateString + "\"");
            return null;
        }
    }

    private static ZonedDateTime tryParseLocalDateTime(String dateString, DateTimeFormatter dateTimeFormatter) {
        try {
            LocalDateTime localDateTime = LocalDateTime.parse(dateString, dateTimeFormatter);
            return ZonedDateTime.of(localDateTime, ZoneId.systemDefault());
        }
        catch (IllegalArgumentException | DateTimeParseException e) {
            log.warn("Invalid Date parsing as LocalDateTime \"" + dateString + "\"");
            return null;
        }
    }

    private static ZonedDateTime tryParseLocalDate(String dateString, DateTimeFormatter dateTimeFormatter) {
        try {
            LocalDate localDate = LocalDate.parse(dateString, dateTimeFormatter);
            return localDate.atStartOfDay(ZoneId.systemDefault());
        }
        catch (IllegalArgumentException | DateTimeParseException e) {
            log.warn("Invalid Date parsing as LocalDate \"" + dateString + "\"");
            return null;
        }
    }
}

