/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.upm.application.servlet;

import com.atlassian.application.api.Application;
import com.atlassian.application.api.ApplicationKey;
import com.atlassian.application.api.ApplicationManager;
import com.atlassian.marketplace.client.model.Product;
import com.atlassian.marketplace.client.model.ProductVersion;
import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.sal.api.auth.LoginUriProvider;
import com.atlassian.sal.api.license.LicenseHandler;
import com.atlassian.sal.api.license.MultiProductLicenseDetails;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.sal.api.websudo.WebSudoManager;
import com.atlassian.soy.renderer.SoyTemplateRenderer;
import com.atlassian.templaterenderer.TemplateRenderer;
import com.atlassian.upm.application.impl.ApplicationAccessor;
import com.atlassian.upm.application.impl.ApplicationActionResultService;
import com.atlassian.upm.application.impl.ApplicationLinkBuilder;
import com.atlassian.upm.application.impl.ApplicationUtil;
import com.atlassian.upm.application.marketplace.ApplicationMarketplaceQueries;
import com.atlassian.upm.application.marketplace.MarketplaceResult;
import com.atlassian.upm.application.marketplace.PlatformVersionInfo;
import com.atlassian.upm.application.rest.representations.ApplicationRepresentation;
import com.atlassian.upm.application.rest.representations.ApplicationRepresentationFactory;
import com.atlassian.upm.core.actionresult.ActionResultCollection;
import com.atlassian.upm.core.policy.PolicyEnforcer;
import com.atlassian.upm.core.rest.resources.permission.PermissionEnforcer;
import com.atlassian.upm.core.servlet.UpmServletHandler;
import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Ordering;
import io.atlassian.fugue.Option;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.servlet.http.HttpServletRequest;
import org.codehaus.jackson.map.ObjectMapper;

public class ApplicationManagerHandler
extends UpmServletHandler {
    public static final String NOTIFICATION_TOKEN_REQ_PARAM_NAME = "notification-token";
    private final ApplicationAccessor applicationAccessor;
    private final ApplicationManager applicationManager;
    private final ApplicationMarketplaceQueries applicationMarketplaceQueries;
    private final ApplicationProperties applicationProperties;
    private final ApplicationRepresentationFactory representationFactory;
    private final ApplicationLinkBuilder linkBuilder;
    private final LicenseHandler licenseHandler;
    private final ObjectMapper objectMapper;
    private final SoyTemplateRenderer soyTemplateRenderer;
    private final ApplicationActionResultService resultService;
    private final UserManager userManager;
    private final PolicyEnforcer policyEnforcer;

    public ApplicationManagerHandler(ApplicationAccessor applicationAccessor, ApplicationManager applicationManager, ApplicationMarketplaceQueries applicationMarketplaceQueries, ApplicationRepresentationFactory representationFactory, ApplicationLinkBuilder linkBuilder, ApplicationProperties applicationProperties, TemplateRenderer renderer, PermissionEnforcer permissionEnforcer, LoginUriProvider loginUriProvider, WebSudoManager webSudoManager, SoyTemplateRenderer soyTemplateRenderer, LicenseHandler licenseHandler, ApplicationActionResultService resultService, UserManager userManager, PolicyEnforcer policyEnforcer) {
        super(renderer, permissionEnforcer, loginUriProvider, webSudoManager);
        this.applicationAccessor = Objects.requireNonNull(applicationAccessor, "applicationAccessor");
        this.applicationManager = Objects.requireNonNull(applicationManager, "applicationManager");
        this.applicationMarketplaceQueries = Objects.requireNonNull(applicationMarketplaceQueries, "applicationMarketplaceQueries");
        this.applicationProperties = Objects.requireNonNull(applicationProperties, "applicationProperties");
        this.representationFactory = Objects.requireNonNull(representationFactory, "representationFactory");
        this.linkBuilder = Objects.requireNonNull(linkBuilder, "linkBuilder");
        this.soyTemplateRenderer = Objects.requireNonNull(soyTemplateRenderer, "soyTemplateRenderer");
        this.licenseHandler = Objects.requireNonNull(licenseHandler, "licenseHandler");
        this.resultService = Objects.requireNonNull(resultService, "resultService");
        this.userManager = Objects.requireNonNull(userManager, "userManager");
        this.objectMapper = new ObjectMapper();
        this.policyEnforcer = Objects.requireNonNull(policyEnforcer, "policyEnforcer");
    }

    @Override
    public Map<String, Object> getContext(HttpServletRequest request) {
        ImmutableMap.Builder paramsBuilder = ImmutableMap.builder();
        List applications = Ordering.from(ApplicationUtil.applicationSorter).sortedCopy(this.applicationManager.getApplications());
        MarketplaceResult availableAppsInfo = this.applicationMarketplaceQueries.getAvailableAppsInfo(true, (Option<Integer>)Option.none());
        MarketplaceResult<Map<String, ProductVersion>> currentPluginAppsInfo = this.applicationMarketplaceQueries.getMpacVersionInfoForInstalledApps(Iterables.filter((Iterable)applications, this.platformCheck(false)));
        Option platformApp = io.atlassian.fugue.Iterables.findFirst((Iterable)applications, this.platformCheck(true));
        Iterable<Product> allAvailableApps = MarketplaceResult.listFromResult(availableAppsInfo);
        Iterable uninstalledAvailableApps = Iterables.filter(allAvailableApps, (Predicate)Predicates.not((Predicate)Predicates.or(ApplicationUtil.productAlreadyInstalled(applications), ApplicationUtil.productHasProductKey(this.getPlatformKey()))));
        ImmutableList applicationReps = ImmutableList.copyOf((Iterable)Iterables.transform((Iterable)applications, this.toApplicationRepresentation(allAvailableApps, (Map)currentPluginAppsInfo.value.getOr(HashMap::new))));
        ImmutableList availableAppReps = ImmutableList.copyOf((Iterable)Iterables.transform((Iterable)uninstalledAvailableApps, ApplicationUtil.toAvailableAppRepresentation(this.representationFactory)));
        ImmutableList<ApplicationRepresentation> uninstalledApplicationLicenses = this.getOrphanedLicenses();
        PlatformVersionInfo platformVersionInfo = this.applicationMarketplaceQueries.getPlatformVersionInfo();
        paramsBuilder.put((Object)"applications", (Object)applicationReps);
        paramsBuilder.put((Object)"availableApps", (Object)availableAppReps);
        paramsBuilder.put((Object)"applicationsJson", (Object)this.serializeAsJson(applicationReps));
        paramsBuilder.put((Object)"availableAppsJson", (Object)this.serializeAsJson(availableAppReps));
        paramsBuilder.put((Object)"links", this.linkBuilder.buildLinksForManageApplicationsPage().build());
        paramsBuilder.put((Object)"uninstalledAppLicenses", (Object)this.serializeAsJson(uninstalledApplicationLicenses));
        paramsBuilder.put((Object)"mpacDisabled", (Object)availableAppsInfo.mpacDisabled);
        paramsBuilder.put((Object)"mpacUnreachable", (Object)availableAppsInfo.mpacUnreachable);
        paramsBuilder.put((Object)"platformName", (Object)this.applicationProperties.getDisplayName());
        paramsBuilder.put((Object)"platformBuildNumber", (Object)platformVersionInfo.getBuildNumber());
        paramsBuilder.put((Object)"username", (Object)this.userManager.getRemoteUser().getUsername());
        paramsBuilder.put((Object)"platformDevVersion", (Object)platformVersionInfo.isDevelopmentVersion());
        paramsBuilder.put((Object)"upmPluginUploadEnabled", (Object)this.policyEnforcer.isPluginUploadEnabled());
        if (this.isDataCenter()) {
            paramsBuilder.put((Object)"dataCenter", (Object)true);
        }
        for (Application p : platformApp) {
            paramsBuilder.put((Object)"platformApplicationName", (Object)p.getName());
        }
        Iterator iterator = platformVersionInfo.knownToMarketplace.iterator();
        while (iterator.hasNext()) {
            boolean knownVersion = (Boolean)iterator.next();
            paramsBuilder.put((Object)"platformUnknownVersion", (Object)(!knownVersion ? 1 : 0));
        }
        for (String token : Option.option((Object)request.getParameter(NOTIFICATION_TOKEN_REQ_PARAM_NAME))) {
            for (ActionResultCollection results : this.resultService.getAndClearResults(token)) {
                paramsBuilder.put((Object)"pageNotifications", (Object)ImmutableList.copyOf(results.get()));
            }
        }
        for (String serverId : Option.option((Object)this.licenseHandler.getServerId())) {
            paramsBuilder.put((Object)"serverId", (Object)serverId);
        }
        return ImmutableMap.of((Object)"soyRenderer", (Object)this.soyTemplateRenderer, (Object)"soyParams", (Object)paramsBuilder.build());
    }

    private boolean isDataCenter() {
        for (MultiProductLicenseDetails lic : this.licenseHandler.getAllProductLicenses()) {
            if (!lic.isDataCenter()) continue;
            return true;
        }
        return false;
    }

    private String getPlatformKey() {
        return this.applicationProperties.getDisplayName().toLowerCase();
    }

    private Function<Application, ApplicationRepresentation> toApplicationRepresentation(Iterable<Product> availableApps, Map<String, ProductVersion> currentAppsInfo) {
        return application -> {
            String productKey = this.applicationAccessor.isPlatform((Application)application) ? this.getPlatformKey() : application.getKey().toString();
            Option product = io.atlassian.fugue.Iterables.findFirst((Iterable)availableApps, ApplicationUtil.productHasProductKey(productKey));
            return this.representationFactory.createApplicationRepresentation((Application)application, (Option<Product>)product, (Option<ProductVersion>)Option.option(currentAppsInfo.get(productKey)));
        };
    }

    private Predicate<Application> platformCheck(final boolean isPlatform) {
        return new Predicate<Application>(){

            public boolean apply(Application app) {
                return ApplicationManagerHandler.this.applicationAccessor.isPlatform(app) == isPlatform;
            }
        };
    }

    private ImmutableList<ApplicationRepresentation> getOrphanedLicenses() {
        ImmutableList.Builder orphanedApps = ImmutableList.builder();
        for (String applicationKeyString : this.licenseHandler.getProductKeys()) {
            ApplicationKey applicationKey = ApplicationKey.valueOf((String)applicationKeyString);
            if (!this.applicationManager.getApplication(applicationKey).isEmpty()) continue;
            orphanedApps.add((Object)this.representationFactory.createEmptyApplicationRepresentationFromLicense(applicationKey, this.licenseHandler.getProductLicenseDetails(applicationKeyString)));
        }
        return orphanedApps.build();
    }

    private String serializeAsJson(Object rep) {
        try {
            return this.objectMapper.writeValueAsString(rep);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

