/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.upm.application.rest.resources;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.codehaus.jackson.annotate.JsonCreator;
import org.codehaus.jackson.annotate.JsonProperty;

public class MultipleApplicationLicenseResponse {
    private final Map<String, LicenseResult> results;
    private final boolean allEvaluationLicenses;

    public static MultipleApplicationLicenseResponse generalError(String error) {
        return new MultipleApplicationLicenseResponse(Collections.singletonMap("no-app-key", new LicenseResult(Collections.singletonList(new LicenseError(error, null)), Collections.emptyList())), false);
    }

    public static MultipleApplicationLicenseResponse empty() {
        return new MultipleApplicationLicenseResponse(Collections.emptyMap(), false);
    }

    @JsonCreator
    public MultipleApplicationLicenseResponse(@JsonProperty(value="results") Map<String, LicenseResult> results, @JsonProperty(value="allEvaluationLicenses") boolean allEvaluationLicenses) {
        this.results = results;
        this.allEvaluationLicenses = allEvaluationLicenses;
    }

    @JsonProperty(value="results")
    public Map<String, LicenseResult> getResults() {
        return this.results;
    }

    @JsonProperty(value="allEvaluationLicenses")
    public boolean isAllEvaluationLicenses() {
        return this.allEvaluationLicenses;
    }

    public boolean hasErrors() {
        return this.results.values().stream().flatMap(r -> r.getErrors().stream()).findFirst().isPresent();
    }

    public static class LicenseWarning {
        private final String message;

        @JsonCreator
        public LicenseWarning(@JsonProperty(value="message") String message) {
            this.message = message;
        }

        @JsonProperty(value="message")
        public String getMessage() {
            return this.message;
        }
    }

    public static class LicenseError {
        private final String message;
        private final Boolean mismatchError;

        @JsonCreator
        public LicenseError(@JsonProperty(value="message") String message, @JsonProperty(value="mismatchError") @Nullable Boolean mismatchError) {
            this.message = message;
            this.mismatchError = mismatchError;
        }

        @JsonProperty(value="message")
        public String getMessage() {
            return this.message;
        }

        @JsonProperty(value="mismatchError")
        public Boolean getMismatchError() {
            return this.mismatchError;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            LicenseError that = (LicenseError)o;
            return new EqualsBuilder().append((Object)this.message, (Object)that.message).append((Object)this.mismatchError, (Object)that.mismatchError).isEquals();
        }

        public int hashCode() {
            return new HashCodeBuilder(17, 37).append((Object)this.message).append((Object)this.mismatchError).toHashCode();
        }
    }

    public static class LicenseResult {
        private final List<LicenseError> errors;
        private final List<LicenseWarning> warnings;

        @JsonCreator
        public LicenseResult(@JsonProperty(value="errors") List<LicenseError> errors, @JsonProperty(value="warnings") List<LicenseWarning> warnings) {
            this.errors = errors;
            this.warnings = warnings;
        }

        @JsonProperty(value="errors")
        public List<LicenseError> getErrors() {
            return this.errors;
        }

        @JsonProperty(value="warnings")
        public List<LicenseWarning> getWarnings() {
            return this.warnings;
        }
    }
}

