/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.upm.application.rest.resources;

import com.atlassian.upm.application.rest.resources.MultipleApplicationLicenseAdapter;
import com.atlassian.upm.application.rest.resources.MultipleApplicationLicenseAdapterFactory;
import com.atlassian.upm.core.permission.Permission;
import com.atlassian.upm.core.rest.resources.permission.PermissionEnforcer;
import java.util.Objects;
import java.util.Set;
import javax.ws.rs.Consumes;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;

@Path(value="/licenses")
public class MultipleApplicationLicenseResource {
    private final PermissionEnforcer permissionEnforcer;
    private final MultipleApplicationLicenseAdapterFactory multipleApplicationLicenseAdapterFactory;

    public MultipleApplicationLicenseResource(PermissionEnforcer permissionEnforcer, MultipleApplicationLicenseAdapterFactory multipleApplicationLicenseAdapterFactory) {
        this.permissionEnforcer = Objects.requireNonNull(permissionEnforcer);
        this.multipleApplicationLicenseAdapterFactory = Objects.requireNonNull(multipleApplicationLicenseAdapterFactory);
    }

    @POST
    @Consumes(value={"application/vnd.atl.plugins+json"})
    @Produces(value={"application/vnd.atl.plugins+json"})
    @Path(value="/validate")
    public Response validateMultipleLicenses(Set<MultipleApplicationLicenseAdapterFactory.LicenseUpdate> updates) {
        this.permissionEnforcer.enforcePermission(Permission.MANAGE_APPLICATION_LICENSES);
        return this.multipleApplicationLicenseAdapterFactory.getAdapter().map(adapter -> adapter.validateAndUpdateMultipleProductLicenses(updates, MultipleApplicationLicenseAdapter.Operation.ValidateOnly)).orElseGet(() -> Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)"This endpoint is not supported in this version of the host application").build());
    }

    @POST
    @Consumes(value={"application/vnd.atl.plugins+json"})
    @Produces(value={"application/vnd.atl.plugins+json"})
    @Path(value="/update")
    public Response validateAndUpdateMultipleLicenses(Set<MultipleApplicationLicenseAdapterFactory.LicenseUpdate> updates) {
        this.permissionEnforcer.enforcePermission(Permission.MANAGE_APPLICATION_LICENSES);
        return this.multipleApplicationLicenseAdapterFactory.getAdapter().map(adapter -> adapter.validateAndUpdateMultipleProductLicenses(updates, MultipleApplicationLicenseAdapter.Operation.ValidateAndUpdate)).orElseGet(() -> Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)"This endpoint is not supported in this version of the host application").build());
    }
}

