/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.upm.application.rest.resources;

import com.atlassian.application.api.Application;
import com.atlassian.application.api.ApplicationKey;
import com.atlassian.application.api.ApplicationManager;
import com.atlassian.upm.application.marketplace.ApplicationMarketplaceQueries;
import com.atlassian.upm.application.rest.representations.ApplicationRepresentationFactory;
import com.atlassian.upm.core.permission.Permission;
import com.atlassian.upm.core.rest.resources.permission.PermissionEnforcer;
import java.util.Iterator;
import java.util.Objects;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;

@Path(value="/installed/{applicationKey}")
public class ApplicationResource {
    private final ApplicationManager applicationManager;
    private final ApplicationRepresentationFactory representationFactory;
    private final ApplicationMarketplaceQueries applicationMarketplaceQueries;
    private final PermissionEnforcer permissionEnforcer;

    public ApplicationResource(ApplicationManager applicationManager, ApplicationMarketplaceQueries applicationMarketplaceQueries, ApplicationRepresentationFactory representationFactory, PermissionEnforcer permissionEnforcer) {
        this.applicationManager = Objects.requireNonNull(applicationManager);
        this.applicationMarketplaceQueries = Objects.requireNonNull(applicationMarketplaceQueries);
        this.representationFactory = Objects.requireNonNull(representationFactory);
        this.permissionEnforcer = Objects.requireNonNull(permissionEnforcer);
    }

    @GET
    @Produces(value={"application/vnd.atl.plugins+json"})
    public Response get(@PathParam(value="applicationKey") String applicationKey) {
        this.permissionEnforcer.enforcePermission(Permission.GET_APPLICATIONS);
        Iterator iterator = this.applicationManager.getApplication(ApplicationKey.valueOf((String)applicationKey)).iterator();
        if (iterator.hasNext()) {
            Application app = (Application)iterator.next();
            return Response.ok((Object)this.representationFactory.createApplicationRepresentation(app, this.applicationMarketplaceQueries.getProductWithLatestVersion(app.getKey().value()), this.applicationMarketplaceQueries.getMpacVersionInfoForInstalledApp(app))).build();
        }
        return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
    }
}

