/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.upm.application.rest.resources;

import com.atlassian.application.api.ApplicationKey;
import com.atlassian.sal.api.i18n.InvalidOperationException;
import com.atlassian.sal.api.license.LicenseHandler;
import com.atlassian.sal.api.license.SingleProductLicenseDetailsView;
import com.atlassian.sal.api.message.LocaleResolver;
import com.atlassian.sal.api.validate.ValidationResult;
import com.atlassian.upm.application.LicenseMismatchDetector;
import com.atlassian.upm.application.rest.representations.ApplicationRepresentationFactory;
import com.atlassian.upm.application.rest.representations.LicenseMismatch;
import com.atlassian.upm.application.rest.resources.MultipleApplicationLicenseAdapter;
import com.atlassian.upm.application.rest.resources.MultipleApplicationLicenseAdapterFactory;
import com.atlassian.upm.application.rest.resources.MultipleApplicationLicenseResponse;
import com.atlassian.upm.core.permission.Permission;
import com.atlassian.upm.core.rest.resources.permission.PermissionEnforcer;
import com.google.common.collect.ImmutableList;
import io.atlassian.fugue.Option;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.codehaus.jackson.annotate.JsonCreator;
import org.codehaus.jackson.annotate.JsonProperty;

@Path(value="/installed/{applicationKey}/license")
public class ApplicationLicenseResource {
    private final ApplicationRepresentationFactory representationFactory;
    private final PermissionEnforcer permissionEnforcer;
    private final LicenseHandler licenseHandler;
    private final LocaleResolver localeResolver;
    private final LicenseMismatchDetector licenseMismatchDetector;
    private final MultipleApplicationLicenseAdapterFactory multipleApplicationLicenseAdapterFactory;

    public ApplicationLicenseResource(ApplicationRepresentationFactory representationFactory, PermissionEnforcer permissionEnforcer, LicenseHandler licenseHandler, LocaleResolver localeResolver, LicenseMismatchDetector licenseMismatchDetector, MultipleApplicationLicenseAdapterFactory multipleApplicationLicenseAdapterFactory) {
        this.representationFactory = Objects.requireNonNull(representationFactory, "representationFactory");
        this.permissionEnforcer = Objects.requireNonNull(permissionEnforcer, "permissionEnforcer");
        this.licenseHandler = Objects.requireNonNull(licenseHandler, "licenseHandler");
        this.localeResolver = Objects.requireNonNull(localeResolver, "localeResolver");
        this.licenseMismatchDetector = Objects.requireNonNull(licenseMismatchDetector);
        this.multipleApplicationLicenseAdapterFactory = Objects.requireNonNull(multipleApplicationLicenseAdapterFactory);
    }

    @GET
    @Produces(value={"application/vnd.atl.plugins+json"})
    public Response get(@PathParam(value="applicationKey") String applicationKey) {
        this.permissionEnforcer.enforcePermission(Permission.GET_APPLICATIONS);
        Option license = Option.option((Object)this.licenseHandler.getProductLicenseDetails(applicationKey));
        return Response.ok((Object)this.representationFactory.createApplicationLicenseRepresentation(ApplicationKey.valueOf((String)applicationKey), (Option<SingleProductLicenseDetailsView>)license)).build();
    }

    @POST
    @Consumes(value={"application/vnd.atl.plugins+json"})
    @Produces(value={"application/vnd.atl.plugins+json"})
    public Response update(@PathParam(value="applicationKey") String applicationKey, ApplicationLicenseUpdateRepresentation license) {
        this.permissionEnforcer.enforcePermission(Permission.MANAGE_APPLICATION_LICENSES);
        Optional<MultipleApplicationLicenseAdapter> optionalAdapter = this.multipleApplicationLicenseAdapterFactory.getAdapter();
        OptionalResponseAndValidationResult pair = optionalAdapter.map(adapter -> this.multipleApplicationLicenseResponseToResponse(adapter.validateMultipleProductLicenses(Collections.singleton(new MultipleApplicationLicenseAdapterFactory.LicenseUpdate(applicationKey, license.getLicenseKey(), false))), license, applicationKey)).orElseGet(() -> {
            ValidationResult validation = this.licenseHandler.validateProductLicense(applicationKey, license.getLicenseKey(), this.localeResolver.getLocale());
            return this.validationResultToResponse(validation, applicationKey);
        });
        return pair.optionalErrorResponse.orElseGet(() -> {
            try {
                this.licenseHandler.addProductLicense(applicationKey, license.getLicenseKey());
            }
            catch (InvalidOperationException e) {
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)this.representationFactory.createValidationResultRepresentation(ValidationResult.withErrorMessages((Iterable)ImmutableList.of((Object)e.getLocalizedMessage())))).build();
            }
            return Response.ok((Object)this.representationFactory.createApplicationLicenseUpdateResultRepresentation(ApplicationKey.valueOf((String)applicationKey), (Option<SingleProductLicenseDetailsView>)Option.some((Object)this.licenseHandler.getProductLicenseDetails(applicationKey)), pair.validationResult, null)).build();
        });
    }

    private OptionalResponseAndValidationResult multipleApplicationLicenseResponseToResponse(MultipleApplicationLicenseResponse multiResponse, ApplicationLicenseUpdateRepresentation license, String applicationKey) {
        ValidationResult validation = ValidationResult.withErrorMessages(this.extractErrors(multiResponse.getResults()));
        Optional<LicenseMismatch> mismatch = this.licenseMismatchDetector.detectLicenseMismatch(multiResponse.getResults(), license.getLicenseKey(), applicationKey);
        if (multiResponse.hasErrors() || mismatch.isPresent()) {
            return new OptionalResponseAndValidationResult(Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)this.representationFactory.createApplicationLicenseUpdateResultRepresentation(ApplicationKey.valueOf((String)applicationKey), (Option<SingleProductLicenseDetailsView>)Option.none(), validation, mismatch.orElse(null))).build(), validation);
        }
        return new OptionalResponseAndValidationResult(validation);
    }

    private OptionalResponseAndValidationResult validationResultToResponse(ValidationResult validationResult, String applicationKey) {
        if (validationResult.hasErrors()) {
            return new OptionalResponseAndValidationResult(Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)this.representationFactory.createApplicationLicenseUpdateResultRepresentation(ApplicationKey.valueOf((String)applicationKey), (Option<SingleProductLicenseDetailsView>)Option.none(), validationResult, null)).build(), validationResult);
        }
        return new OptionalResponseAndValidationResult(validationResult);
    }

    private Set<String> extractErrors(Map<String, MultipleApplicationLicenseResponse.LicenseResult> results) {
        return results.values().stream().flatMap(r -> r.getErrors().stream().map(MultipleApplicationLicenseResponse.LicenseError::getMessage)).collect(Collectors.toSet());
    }

    @DELETE
    @Produces(value={"application/vnd.atl.plugins+json"})
    public Response remove(@PathParam(value="applicationKey") String applicationKey) {
        this.permissionEnforcer.enforcePermission(Permission.MANAGE_APPLICATION_LICENSES);
        try {
            this.licenseHandler.removeProductLicense(applicationKey);
            return Response.noContent().build();
        }
        catch (InvalidOperationException e) {
            ValidationResult validation = ValidationResult.withErrorMessages((Iterable)ImmutableList.of((Object)e.getLocalizedMessage()));
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)this.representationFactory.createValidationResultRepresentation(validation)).build();
        }
    }

    private static class OptionalResponseAndValidationResult {
        public final Optional<Response> optionalErrorResponse;
        public final ValidationResult validationResult;

        public OptionalResponseAndValidationResult(Response optionalErrorResponse, ValidationResult validationResult) {
            this.optionalErrorResponse = Optional.ofNullable(optionalErrorResponse);
            this.validationResult = validationResult;
        }

        public OptionalResponseAndValidationResult(ValidationResult validationResult) {
            this(null, validationResult);
        }
    }

    public static final class ApplicationLicenseUpdateRepresentation {
        @JsonProperty
        private String licenseKey;

        @JsonCreator
        public ApplicationLicenseUpdateRepresentation(@JsonProperty(value="licenseKey") String licenseKey) {
            this.licenseKey = licenseKey;
        }

        public String getLicenseKey() {
            return this.licenseKey;
        }
    }
}

