/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.upm.application.rest.resources;

import com.atlassian.application.api.ApplicationManager;
import com.atlassian.upm.application.marketplace.AppUpdateInfo;
import com.atlassian.upm.application.marketplace.ApplicationMarketplaceQueries;
import com.atlassian.upm.application.marketplace.MarketplaceResult;
import com.atlassian.upm.application.rest.representations.ApplicationRepresentationFactory;
import com.atlassian.upm.application.rest.representations.ApplicationUpdateCollectionRepresentation;
import com.atlassian.upm.core.permission.Permission;
import com.atlassian.upm.core.rest.resources.permission.PermissionEnforcer;
import java.util.Objects;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;

@Path(value="/updates")
public class AppUpdatesResource {
    private final ApplicationManager applicationManager;
    private final ApplicationRepresentationFactory representationFactory;
    private final ApplicationMarketplaceQueries applicationMarketplaceQueries;
    private final PermissionEnforcer permissionEnforcer;

    public AppUpdatesResource(ApplicationManager applicationManager, ApplicationMarketplaceQueries applicationMarketplaceQueries, ApplicationRepresentationFactory representationFactory, PermissionEnforcer permissionEnforcer) {
        this.applicationManager = Objects.requireNonNull(applicationManager, "applicationManager");
        this.applicationMarketplaceQueries = Objects.requireNonNull(applicationMarketplaceQueries, "applicationMarketplaceQueries");
        this.representationFactory = Objects.requireNonNull(representationFactory, "representationFactory");
        this.permissionEnforcer = Objects.requireNonNull(permissionEnforcer, "permissionEnforcer");
    }

    @GET
    @Produces(value={"application/vnd.atl.plugins+json"})
    public Response get(@QueryParam(value="buildNumber") int platformBuildNumber) {
        this.permissionEnforcer.enforcePermission(Permission.GET_APPLICATIONS);
        Iterable installedApps = this.applicationManager.getApplications();
        Iterable<AppUpdateInfo> updates = MarketplaceResult.listFromResult(this.applicationMarketplaceQueries.getAppUpdateInfo(platformBuildNumber, installedApps));
        ApplicationUpdateCollectionRepresentation rep = this.representationFactory.createApplicationUpdateCollectionRepresentation(updates);
        return Response.ok((Object)rep).build();
    }
}

