/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.upm.application.impl;

import com.atlassian.application.api.Application;
import com.atlassian.application.api.ApplicationPlugin;
import com.atlassian.application.api.PlatformApplication;
import com.atlassian.marketplace.client.model.Product;
import com.atlassian.marketplace.client.model.ProductVersion;
import com.atlassian.upm.application.rest.representations.ApplicationRepresentationFactory;
import com.atlassian.upm.application.rest.representations.AvailableAppRepresentation;
import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;

public abstract class ApplicationUtil {
    public static final Comparator<Application> applicationSorter = (app1, app2) -> {
        if (app1 instanceof PlatformApplication) {
            return 1;
        }
        if (app2 instanceof PlatformApplication) {
            return -1;
        }
        return app1.getName().compareTo(app2.getName());
    };

    public static Function<Application, String> applicationKey() {
        return application -> application.getKey().value();
    }

    public static Function<ApplicationPlugin, String> applicationPluginKey() {
        return ApplicationPlugin::getPluginKey;
    }

    public static Predicate<Product> productAlreadyInstalled(Iterable<Application> installedApps) {
        ImmutableSet installedKeys = ImmutableSet.copyOf((Collection)StreamSupport.stream(installedApps.spliterator(), false).map(application -> application.getKey().toString()).collect(Collectors.toList()));
        return arg_0 -> ApplicationUtil.lambda$productAlreadyInstalled$3((Set)installedKeys, arg_0);
    }

    public static Predicate<Product> productAlreadyInstalledWithSameVersion(Map<String, String> installedAppVersions) {
        return p -> {
            Iterator iterator = p.getVersion().iterator();
            if (iterator.hasNext()) {
                ProductVersion v = (ProductVersion)iterator.next();
                return v.getName().equals(installedAppVersions.get(p.getKey()));
            }
            return false;
        };
    }

    public static Predicate<Product> productHasProductKey(String key) {
        return Predicates.compose((Predicate)Predicates.equalTo((Object)key), ApplicationUtil.productProductKey());
    }

    public static Function<Product, String> productProductKey() {
        return Product::getKey;
    }

    public static Function<Product, AvailableAppRepresentation> toAvailableAppRepresentation(ApplicationRepresentationFactory factory) {
        return factory::createAvailableAppRepresentation;
    }

    private static /* synthetic */ boolean lambda$productAlreadyInstalled$3(Set installedKeys, Product p) {
        return installedKeys.contains(p.getKey());
    }
}

