/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.upm;

import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.osgi.factory.OsgiPlugin;
import com.atlassian.upm.api.util.Option;
import com.atlassian.upm.impl.DateUtil;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Optional;
import org.joda.time.DateTime;
import org.osgi.framework.Bundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class PluginMetadata {
    private static final Logger log = LoggerFactory.getLogger(PluginMetadata.class);
    public static final String BUILD_DATE_ATTRIBUTE = "Atlassian-Build-Date";
    private static final DateTimeFormatter BUILD_DATE_FORMAT = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ssZ");

    @Deprecated
    public static Option<DateTime> getPluginBuildDate(Option<Plugin> maybePlugin) {
        return DateUtil.toOptionDateTime(PluginMetadata.getPluginBuildZonedDate(maybePlugin));
    }

    public static Optional<ZonedDateTime> getPluginBuildZonedDate(Option<Plugin> maybePlugin) {
        for (Plugin plugin : maybePlugin) {
            for (Bundle bundle : PluginMetadata.getPluginBundle(plugin)) {
                if (bundle == null) {
                    return Optional.empty();
                }
                Object value = bundle.getHeaders().get(BUILD_DATE_ATTRIBUTE);
                if (value == null) continue;
                return Optional.ofNullable(DateUtil.parseZonedDatetime(value.toString(), BUILD_DATE_FORMAT));
            }
        }
        return Optional.empty();
    }

    public static Option<Bundle> getPluginBundle(Plugin plugin) {
        if (plugin instanceof OsgiPlugin) {
            return Option.option(((OsgiPlugin)plugin).getBundle());
        }
        return Option.none();
    }
}

