/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.upm.test;

import com.atlassian.upm.api.license.entity.LicenseType;
import com.atlassian.upm.api.util.Option;
import com.google.common.collect.ImmutableList;
import java.net.URI;

public enum TestPlugins {
    BROKEN_XML_PLUGIN("invalid-xml-artifact", "Invalid XML plugin artifact"),
    BUNDLED("test-plugin-v2-bundled", "Test Plugin v2 (bundled)"),
    BUNDLED_RBP("test-plugin-v2-bundled-rbp", "Test Plugin v2 (bundled RBP)"),
    BUNDLED_NO_UPDATE("test-plugin-v2-bundled-has-no-update", "Test Plugin v2 (Has No Update)"),
    BUNDLED_WITH_CONFIG("test-plugin-v2-bundled-with-config", "Test Plugin v2 (bundled with config, also bundled in Cloud)"),
    CANNOT_DISABLE_MODULE("test-plugin-v2-cannot-disable-module", "Test Plugin v2 (cannot disable module)"),
    CANNOT_DISABLE_PLUGIN("test-plugin-v2-cannot-be-disabled", "Test Plugin v2 (cannot disable plugin)"),
    FLAGGED_AS_SYSTEM_REQUIRED("test-plugin-v2-flagged-as-system-required", "Test Plugin v2 (flagged as system, required)"),
    INSTALLABLE("test-plugin-v2-installable", "Test Plugin v2 (installable)"),
    JIRA_CALENDAR("com.atlassian.jira.ext.calendar", "JIRA Calendar Plugin"),
    JIRA_CHART("com.atlassian.jira.ext.charting", "JIRA Charting Plugin"),
    LEGACY_PLUGIN("test-plugin-v1-installable", "Test Plugin v1 (installable)"),
    LEGACY_PLUGIN_NOT_BUNDLED("test-plugin-v1-nonbundled", "Test Plugin v1 (not bundled)"),
    LICENSE_CHECKER("com.atlassian.upm.license-checker-test-plugin", "License Checker Test Plugin"),
    LICENSE_CHECKER_ROLE_BASED("com.atlassian.upm.license-checker-test-plugin-role-based", "License Checker Test Plugin  (Role Based)"),
    MARKETPLACE("test-plugin-v2-marketplace", "Test Plugin v2 (Sold on Atlassian Marketplace)"),
    MARKETPLACE_WITH_POST_INSTALL_URL("test-plugin-v2-marketplace-with-post-install", "Test Plugin v2 (Marketplace with post-install URL)"),
    NONDEPLOYABLE("non-deployable-test-plugin", "Non-deployable test plugin"),
    NOT_RELOADABLE("test-plugin-v2-not-reloadable", "Test Plugin v2 (not reloadable)"),
    OBR("com.atlassian.upm.atlassian-universal-plugin-manager-test-plugin-v2-obr", "Installable Test OBR Plugin"),
    OBR_DEP("com.atlassian.upm.atlassian-universal-plugin-manager-test-plugin-v2-obr-dep", "Installable Test OBR Plugin Dependency"),
    OSGI_BUNDLE("com.atlassian.upm.atlassian-universal-plugin-manager-test-osgi-bundle-1.0", "Test OSGi Bundle"),
    REMOTABLE_FREE("test-plugin-v3-remotable-free", "Test Plugin v3 (remotable, free)"),
    REMOTABLE_MARKETPLACE("test-plugin-v3-remotable-marketplace", "Test Plugin v3 (remotable, marketplace)"),
    CLOUD_MARKETPLACE_F45("test-plugin-v3-cloud-f45", "Test Plugin v3 (cloud, free for 5)"),
    REMOTABLE_SCOPES("test-plugin-v3-remotable-scopes", "Test Plugin v3 (remotable, requires scopes)"),
    ROLE_BASED_PRICING_SPI("com.atlassian.upm.role-based-licensing-plugin", "Universal Plugin Manager - Role-Based Licensing Implementation Plugin"),
    STATIC("test-plugin-v1-classpath", "Test Plugin v1 (classpath)"),
    SYSTEM("test-plugin-v2-system", "Test Plugin v2 (system)"),
    UPDATABLE_BUNDLED("test-plugin-v2-bundled-updatable", "Test Plugin v2 (updatable bundled)"),
    UPDATABLE_REQUIRES_RESTART("test-plugin-v2-updatable-requires-restart", "Test Plugin v2 (updatable, requires restart, v1.0)"),
    USER_INSTALLED_WITH_MODULES("test-plugin-v2-user-installed-with-modules", "User installed test plugin with modules"),
    XML_PLUGIN("test-plugin-v2-xml-plugin-artifact", "Test Plugin v2 (xml plugin artifact)"),
    LEGACY_DATA_CENTER_COMPATIBILITY("test-plugin-v2-legacy-data-center-compatibility", "Test Plugin v2 (Using legacy data center compatibility flag)"),
    BONFIRE("com.atlassian.bonfire.plugin", "Atlassian Bonfire - JIRA Plugin"),
    GREENHOPPER("com.pyxis.greenhopper.jira", "Atlassian GreenHopper"),
    TEAM_CALENDARS("com.atlassian.confluence.extra.team-calendars", "Team Calendars"),
    ATLASSIAN_CONNECT("com.atlassian.plugins.atlassian-connect-plugin", "Atlassian Connect - Plugin"),
    UPM("com.atlassian.upm.atlassian-universal-plugin-manager-plugin", "Atlassian Universal Plugin Manager Plugin");

    public static final String USER_INSTALLED_MODULE_KEY = "some_module";
    public static final String LICENSE_CHECKER_MODULE_KEY = "licenseServlet";
    public static final String FAKE_PAC = "com.atlassian.upm.fake-pac-plugin";
    public static final String INSTALLABLE_PLUGIN_PATH = "atlassian-universal-plugin-manager-test-plugin-v2-installable.jar";
    private static final String JAR_DOWNLOAD_PATH = "/rest/fakempac/1.0/plugins/";
    private static final String JAR_DOWNLOAD_QUERY_STRING_PATH = "/rest/fakempac/1.0/downloadServlet?name=";
    public static final String HIGHER_APP_VERSION = "98.0.0.HigherVersion";
    public static final String MAX_APP_VERSION = "99.0.0.HighestVersion";
    public static final int HIGHER_APP_BUILD_NUMBER = 999999998;
    public static final int MAX_APP_BUILD_NUMBER = 999999999;
    private final String key;
    private final String name;

    private TestPlugins(String key) {
        this(key, "");
    }

    private TestPlugins(String key, String name) {
        this.key = key;
        this.name = name;
    }

    public static Option<TestPlugins> fromKey(String key) {
        for (TestPlugins p : TestPlugins.values()) {
            if (!p.key.equals(key)) continue;
            return Option.some((Object)((Object)p));
        }
        return Option.none();
    }

    public static String escapeKey(String key) {
        return key + "-key";
    }

    public String getKey() {
        return this.key;
    }

    public String getOnDemandKey() {
        return this.key + ".ondemand";
    }

    public String getName() {
        return this.name;
    }

    public boolean isListedOnMpac() {
        return !this.name.equals("");
    }

    public Iterable<String> getCategories() {
        switch (this) {
            case UPM: {
                return ImmutableList.of((Object)"Admin Tools");
            }
            case REMOTABLE_FREE: {
                return ImmutableList.of((Object)"Remotable");
            }
            case BUNDLED: {
                return ImmutableList.of((Object)"Bundled");
            }
        }
        return ImmutableList.of();
    }

    public boolean isDeployable() {
        switch (this) {
            case NONDEPLOYABLE: {
                return false;
            }
        }
        return !this.isRemotable();
    }

    public Iterable<String> getRequiredScopeKeys() {
        switch (this) {
            case REMOTABLE_SCOPES: {
                return ImmutableList.of((Object)"read", (Object)"write");
            }
        }
        return ImmutableList.of();
    }

    public URI getDownloadUri(URI baseUri) {
        return TestPlugins.getDownloadUri(this.key, baseUri);
    }

    public URI getQueryStringDownloadUri(URI baseUri) {
        return URI.create(baseUri.toASCIIString() + JAR_DOWNLOAD_QUERY_STRING_PATH + this.key).normalize();
    }

    public static URI getDownloadUri(String pluginKey, URI baseUri) {
        return URI.create(baseUri.toASCIIString() + JAR_DOWNLOAD_PATH + pluginKey).normalize();
    }

    public static URI getDownloadUri(String pluginKey, String version, URI baseUri) {
        return URI.create(baseUri.toASCIIString() + JAR_DOWNLOAD_PATH + pluginKey + "/" + version).normalize();
    }

    public boolean isFree() {
        return !this.isPaidViaAtlassian() && !this.isPaidViaVendor();
    }

    public boolean isPaidViaAtlassian() {
        switch (this) {
            case MARKETPLACE: 
            case MARKETPLACE_WITH_POST_INSTALL_URL: 
            case REMOTABLE_MARKETPLACE: 
            case USER_INSTALLED_WITH_MODULES: 
            case LICENSE_CHECKER_ROLE_BASED: 
            case BUNDLED_RBP: 
            case UPDATABLE_BUNDLED: 
            case LICENSE_CHECKER: 
            case CLOUD_MARKETPLACE_F45: {
                return true;
            }
        }
        return false;
    }

    public boolean isPaidViaVendor() {
        return this == NONDEPLOYABLE;
    }

    public String getMarketplaceType() {
        return this.isPaidViaAtlassian() ? "Paid via Atlassian" : (this.isPaidViaVendor() ? "Paid via Vendor" : "Free");
    }

    public Option<Float> getMarketplacePricing(LicenseType licenseType, int userCount) {
        switch (this) {
            case MARKETPLACE: 
            case MARKETPLACE_WITH_POST_INSTALL_URL: 
            case REMOTABLE_MARKETPLACE: 
            case LICENSE_CHECKER_ROLE_BASED: 
            case BUNDLED_RBP: 
            case UPDATABLE_BUNDLED: 
            case CLOUD_MARKETPLACE_F45: {
                float fiveUserPrice = licenseType == LicenseType.ACADEMIC ? 11.0f : 23.0f;
                return Option.some((Object)Float.valueOf((float)Math.floor(fiveUserPrice * (float)userCount / 5.0f)));
            }
        }
        return Option.none();
    }

    public String getPluginSystemVersion() {
        switch (this) {
            case LEGACY_PLUGIN: 
            case LEGACY_PLUGIN_NOT_BUNDLED: 
            case STATIC: {
                return "One";
            }
        }
        return this.isRemotable() ? "Three" : "Two";
    }

    public String getPluginSystemNumericVersion() {
        String psv = this.getPluginSystemVersion();
        return psv.equals("Three") ? "3" : (psv.equals("One") ? "1" : "2");
    }

    public String getVendorName() {
        switch (this) {
            case UPM: 
            case INSTALLABLE: 
            case JIRA_CALENDAR: 
            case JIRA_CHART: {
                return "Atlassian";
            }
        }
        return "Test Vendor";
    }

    public String getArtifactBaseName() {
        switch (this) {
            case OSGI_BUNDLE: {
                return "atlassian-universal-plugin-manager-test-osgi-bundle";
            }
            case UPDATABLE_REQUIRES_RESTART: {
                return "atlassian-universal-plugin-manager-test-plugin-v2-updatable-requires-restart-2.0";
            }
            case LICENSE_CHECKER_ROLE_BASED: {
                return "atlassian-universal-plugin-manager-test-plugin-v2-license-checker-role-based";
            }
        }
        return this.key;
    }

    public boolean isBundledInServer() {
        switch (this) {
            case BUNDLED: 
            case BUNDLED_RBP: 
            case BUNDLED_NO_UPDATE: {
                return true;
            }
        }
        return false;
    }

    public boolean isBundledInCloud() {
        switch (this) {
            case BUNDLED_NO_UPDATE: 
            case BUNDLED_WITH_CONFIG: {
                return true;
            }
        }
        return false;
    }

    public boolean isRemotable() {
        switch (this) {
            case REMOTABLE_FREE: 
            case REMOTABLE_SCOPES: 
            case REMOTABLE_MARKETPLACE: 
            case CLOUD_MARKETPLACE_F45: {
                return true;
            }
        }
        return false;
    }

    public boolean isRoleBased() {
        switch (this) {
            case LICENSE_CHECKER_ROLE_BASED: 
            case BUNDLED_RBP: {
                return true;
            }
        }
        return false;
    }

    public Option<TestPluginRole> getRole() {
        return this.isRoleBased() ? Option.some((Object)new TestPluginRole("Agent", "Agents")) : Option.none(TestPluginRole.class);
    }

    public boolean canContactForMorePricing() {
        switch (this) {
            case LICENSE_CHECKER_ROLE_BASED: {
                return true;
            }
        }
        return false;
    }

    public Option<URI> getDescriptorUri(URI baseUri) {
        if (this.isRemotable()) {
            return Option.some((Object)URI.create(baseUri.toASCIIString() + "/rest/fakempac/1.0/download/plugins/" + this.getKey() + "/1.0/descriptor"));
        }
        return Option.none();
    }

    public static class TestPluginRole {
        private String singularName;
        private String pluralName;

        public TestPluginRole(String singularName, String pluralName) {
            this.singularName = singularName;
            this.pluralName = pluralName;
        }

        public String getSingularName() {
            return this.singularName;
        }

        public String getPluralName() {
            return this.pluralName;
        }
    }
}

