package com.atlassian.upm.license.role.spi;

import static com.google.common.base.Preconditions.checkNotNull;

/**
 * This is an abstract licensing role to provide an implementation for common licensing role functionality.
 */
public abstract class AbstractLicensingRole implements LicensingRole
{
    private final String key;
    private final String nameI18nKey;
    private final String descriptionI18nKey;

    public AbstractLicensingRole(String key, String nameI18nKey, String descriptionI18nKey)
    {
        this.key = checkNotNull(key, "key");
        this.nameI18nKey = nameI18nKey;
        this.descriptionI18nKey = descriptionI18nKey;
    }

    @Override
    public String getKey()
    {
        return key;
    }

    @Override
    public String getNameI18nKey()
    {
        return nameI18nKey;
    }

    @Override
    public String getDescriptionI18nKey()
    {
        return descriptionI18nKey;
    }
}
