package com.atlassian.upm.license.role.jira;

import com.atlassian.plugin.Plugin;
import com.atlassian.pocketknife.api.lifecycle.modules.DynamicModuleDescriptorFactory;
import com.atlassian.pocketknife.api.lifecycle.modules.ModuleRegistrationHandle;
import com.atlassian.upm.license.role.spi.LicensingRoleCreationFailedException;

import org.dom4j.Attribute;
import org.dom4j.Element;
import org.dom4j.tree.DefaultAttribute;
import org.dom4j.tree.DefaultElement;

public class DynamicGlobalPermissionServiceImpl implements DynamicGlobalPermissionService {

    private static final String GLOBAL_PERMISSION_ROOT_NAME = "global-permission";

    private final DynamicModuleDescriptorFactory dynamicModuleDescriptorFactory;

    public DynamicGlobalPermissionServiceImpl(DynamicModuleDescriptorFactory dynamicModuleDescriptorFactory)
    {
        this.dynamicModuleDescriptorFactory = dynamicModuleDescriptorFactory;
    }

    @Override
    public ModuleRegistrationHandle dynamicallyCreatePermission(Plugin plugin, String key, String nameI18nKey, String descriptionI18nKey) throws LicensingRoleCreationFailedException
    {
        try
        {
            Element globalPermissionElement = createElementForGlobalPermission(key, nameI18nKey, descriptionI18nKey);
            return dynamicModuleDescriptorFactory.loadModules(plugin, globalPermissionElement);
        }
        catch (Exception e)
        {
            throw new LicensingRoleCreationFailedException("Failed to create global permission", e);
        }
    }

    // Creates an element from scratch - as if it were read out of an xml file!
    private Element createElementForGlobalPermission(String key, String nameI18nKey, String descriptionI18nKey)
    {
        Element rootElement = new DefaultElement(GLOBAL_PERMISSION_ROOT_NAME);
        Attribute keyAttribute = new DefaultAttribute("key", key);
        Attribute nameAttribute = new DefaultAttribute("i18n-name-key", nameI18nKey);
        Attribute descriptionAttribute = new DefaultAttribute("i18n-description-key", descriptionI18nKey);
        // Never anonymous allowed because these groups are for licenses
        Attribute anonymousAllowedAttribute = new DefaultAttribute("anonymous-allowed", "false");

        rootElement.add(keyAttribute);
        rootElement.add(nameAttribute);
        rootElement.add(descriptionAttribute);
        rootElement.add(anonymousAllowedAttribute);

        return rootElement;
    }
}
