package com.atlassian.upm.license.role.jira;

import com.atlassian.plugin.Plugin;
import com.atlassian.pocketknife.api.lifecycle.modules.ModuleRegistrationHandle;
import com.atlassian.upm.license.role.spi.LicensingRoleCreationFailedException;

public interface DynamicGlobalPermissionService {

    /**
     * Creates a global permission module descriptor and registers it.
     *
     * @param plugin             plugin to which the global permission should be added
     * @param key                key of the global permission
     * @param nameI18nKey        i18n key for the global permissions name
     * @param descriptionI18nKey i18n key for the global permissions description
     * @return a handle for the created dynamic module. That handle is used to un-register the descriptor later on. It is a good idea to hold onto it.
     */
    ModuleRegistrationHandle dynamicallyCreatePermission(Plugin plugin, String key, String nameI18nKey, String descriptionI18nKey) throws LicensingRoleCreationFailedException;
}
