package com.atlassian.upm.license.storage.lib;

import com.atlassian.upm.license.storage.plugin.PluginLicenseStorageManager;

/**
 * Accessor for {@link PluginLicenseStorageManager}.
 */
public interface ThirdPartyPluginLicenseStorageManagerAccessor
{
    /**
     * Returns a {@link com.atlassian.upm.license.storage.plugin.PluginLicenseStorageManager}, if one exists.
     * It is *not* safe to cache the returned value. It should be re-fetched when executing multiple atomic tasks.
     * 
     * @return a {@link com.atlassian.upm.license.storage.plugin.PluginLicenseStorageManager}, if one exists.
     * @throws PluginLicenseStoragePluginUnresolvedException if the Plugin License Storage plugin is required but unavailable 
     */
    PluginLicenseStorageManager getPluginLicenseStorageManager() throws PluginLicenseStoragePluginUnresolvedException;
}