package com.atlassian.upm.license.storage.lib;

import com.atlassian.upm.api.license.PluginLicenseManager;

/**
 * Accessor for {@link PluginLicenseManager}.
 */
public interface PluginLicenseManagerAccessor
{
    /**
     * Returns a {@link PluginLicenseManager}, if one exists.
     * It is *not* safe to cache the returned value. It should be re-fetched when executing multiple atomic tasks.
     *
     * @return a {@link PluginLicenseManager}, if one exists.
     */
    PluginLicenseManager getPluginLicenseManager();
}
