/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.marketplace.client.model;

import com.atlassian.marketplace.client.model.ApplicationSummary;
import com.atlassian.marketplace.client.model.Links;
import com.atlassian.marketplace.client.model.Modification;
import com.atlassian.marketplace.client.model.PluginCategory;
import com.atlassian.marketplace.client.model.PluginMedia;
import com.atlassian.marketplace.client.model.PluginVersion;
import com.atlassian.marketplace.client.model.Pricing;
import com.atlassian.marketplace.client.model.ReviewSummary;
import com.atlassian.marketplace.client.model.Reviews;
import com.atlassian.marketplace.client.model.Vendor;
import com.atlassian.marketplace.client.util.ModelUtil;
import com.atlassian.upm.api.util.Option;
import com.google.common.collect.ImmutableList;
import java.net.URI;
import java.util.Collection;
import java.util.Date;
import org.codehaus.jackson.annotate.JsonCreator;
import org.codehaus.jackson.annotate.JsonIgnore;
import org.codehaus.jackson.annotate.JsonProperty;

public final class Plugin {
    @JsonProperty
    private final Links links;
    @JsonProperty
    private final Date creationDate;
    @JsonProperty
    private final String name;
    @JsonProperty
    private final String pluginKey;
    @JsonProperty
    private final String description;
    @JsonProperty
    private final String summary;
    @JsonProperty
    private final boolean deployable;
    @JsonProperty
    private final long downloadCount;
    @JsonProperty
    private final Modification lastModified;
    @JsonProperty
    private final Vendor vendor;
    @JsonProperty
    private final PluginMedia media;
    @JsonProperty
    private final ReviewSummary reviewSummary;
    @JsonProperty
    private final Reviews reviews;
    @JsonProperty
    private final Collection<PluginCategory> categories;
    @JsonProperty
    private final PluginVersion version;
    @JsonProperty
    private final PluginVersions versions;
    @JsonProperty
    private final boolean isOldVersion;
    @JsonProperty
    private final Collection<ApplicationSummary> compatibleApplications;
    @JsonProperty
    private final Pricing pricing;
    private final URI webUri;

    @JsonCreator
    Plugin(@JsonProperty(value="links") Links links, @JsonProperty(value="creationDate") Date creationDate, @JsonProperty(value="name") String name, @JsonProperty(value="pluginKey") String pluginKey, @JsonProperty(value="description") String description, @JsonProperty(value="summary") String summary, @JsonProperty(value="deployable") Boolean deployable, @JsonProperty(value="downloadCount") Long downloadCount, @JsonProperty(value="lastModified") Modification lastModified, @JsonProperty(value="vendor") Vendor vendor, @JsonProperty(value="media") PluginMedia media, @JsonProperty(value="reviewSummary") ReviewSummary reviewSummary, @JsonProperty(value="reviews") Reviews reviews, @JsonProperty(value="categories") Collection<PluginCategory> categories, @JsonProperty(value="version") PluginVersion version, @JsonProperty(value="versions") PluginVersions versions, @JsonProperty(value="isOldVersion") Boolean isOldVersion, @JsonProperty(value="compatibleApplications") Collection<ApplicationSummary> compatibleApplications, @JsonProperty(value="pricing") Pricing pricing) {
        this.links = ModelUtil.requireProperty(links, "links");
        this.creationDate = ModelUtil.requireProperty(creationDate, "creationDate");
        this.name = ModelUtil.requireProperty(name, "name");
        this.pluginKey = ModelUtil.requireProperty(pluginKey, "pluginKey");
        this.description = description;
        this.summary = summary;
        this.deployable = ModelUtil.requireProperty(deployable, "deployable");
        this.downloadCount = ModelUtil.requireProperty(downloadCount, "downloadCount");
        this.lastModified = lastModified;
        this.vendor = vendor;
        this.media = ModelUtil.requireProperty(media, "media");
        this.reviewSummary = ModelUtil.requireProperty(reviewSummary, "reviewSummary");
        this.reviews = ModelUtil.requireProperty(reviews, "reviews");
        this.categories = ModelUtil.requireList(categories, "categories");
        this.version = ModelUtil.requireProperty(version, "version");
        this.versions = ModelUtil.requireProperty(versions, "versions");
        this.isOldVersion = ModelUtil.requireProperty(isOldVersion, "isOldVersion");
        this.compatibleApplications = ModelUtil.requireList(compatibleApplications, "compatibleApplications");
        this.pricing = pricing;
        this.webUri = ModelUtil.requireLink(links, "alternate");
    }

    public Links getLinks() {
        return this.links;
    }

    public Date getCreationDate() {
        return this.creationDate;
    }

    public String getName() {
        return this.name;
    }

    public String getPluginKey() {
        return this.pluginKey;
    }

    @JsonIgnore
    public Option<String> getDescription() {
        return Option.option((Object)this.description);
    }

    @JsonIgnore
    public Option<String> getSummary() {
        return Option.option((Object)this.summary);
    }

    public boolean isDeployable() {
        return this.deployable;
    }

    public long getDownloadCount() {
        return this.downloadCount;
    }

    @JsonIgnore
    public Option<Modification> getLastModified() {
        return Option.option((Object)this.lastModified);
    }

    @JsonIgnore
    public Option<Vendor> getVendor() {
        return Option.option((Object)this.vendor);
    }

    public PluginMedia getMedia() {
        return this.media;
    }

    public ReviewSummary getReviewSummary() {
        return this.reviewSummary;
    }

    public Reviews getReviews() {
        return this.reviews;
    }

    @JsonIgnore
    public Iterable<PluginCategory> getCategories() {
        return ImmutableList.copyOf(this.categories);
    }

    public PluginVersion getVersion() {
        return this.version;
    }

    @JsonIgnore
    public int getVersionCount() {
        return this.versions.getCount();
    }

    @JsonIgnore
    public Iterable<PluginVersion> getVersions() {
        return this.versions.getVersions();
    }

    public boolean isOldVersion() {
        return this.isOldVersion;
    }

    @JsonIgnore
    public Iterable<ApplicationSummary> getCompatibleApplications() {
        return ImmutableList.copyOf(this.compatibleApplications);
    }

    @JsonIgnore
    public Option<Pricing> getPricing() {
        return Option.option((Object)this.pricing);
    }

    @JsonIgnore
    public URI getWebUri() {
        return this.webUri;
    }

    public static final class PluginVersions {
        @JsonProperty
        private final Collection<PluginVersion> versions;
        @JsonProperty
        private final int count;

        @JsonCreator
        PluginVersions(@JsonProperty(value="versions") Collection<PluginVersion> versions, @JsonProperty(value="count") Integer count) {
            this.versions = ModelUtil.requireList(versions, "versions");
            this.count = ModelUtil.requireProperty(count, "count");
        }

        @JsonIgnore
        public Iterable<PluginVersion> getVersions() {
            return ImmutableList.copyOf(this.versions);
        }

        public int getCount() {
            return this.count;
        }
    }
}

