/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.marketplace.client.model;

import com.atlassian.marketplace.client.api.ApplicationKey;
import com.atlassian.marketplace.client.model.ApplicationVersion;
import com.atlassian.marketplace.client.model.Links;
import com.atlassian.marketplace.client.util.ModelUtil;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import org.codehaus.jackson.annotate.JsonCreator;
import org.codehaus.jackson.annotate.JsonIgnore;
import org.codehaus.jackson.annotate.JsonProperty;

public final class Application {
    @JsonProperty
    private final Links links;
    @JsonProperty
    private final String key;
    @JsonProperty
    private final String name;
    @JsonProperty
    private final int order;
    @JsonProperty
    private final int pluginCount;
    @JsonProperty
    private final Collection<ApplicationVersion> versions;
    @JsonProperty
    private final Collection<String> categories;

    @JsonCreator
    Application(@JsonProperty(value="links") Links links, @JsonProperty(value="key") String key, @JsonProperty(value="name") String name, @JsonProperty(value="order") Integer order, @JsonProperty(value="pluginCount") Integer pluginCount, @JsonProperty(value="versions") Collection<ApplicationVersion> versions, @JsonProperty(value="categories") Collection<String> categories) {
        this.links = ModelUtil.requireProperty(links, "links");
        this.key = ModelUtil.requireProperty(key, "key");
        this.name = ModelUtil.requireProperty(name, "name");
        this.order = ModelUtil.requireProperty(order, "order");
        this.pluginCount = ModelUtil.requireProperty(pluginCount, "pluginCount");
        this.versions = ModelUtil.requireList(versions, "versions");
        this.categories = ModelUtil.requireList(categories, "categories");
    }

    public Links getLinks() {
        return this.links;
    }

    @JsonIgnore
    public ApplicationKey getKey() {
        return ApplicationKey.valueOf(this.key);
    }

    public String getName() {
        return this.name;
    }

    public int getOrder() {
        return this.order;
    }

    public int getPluginCount() {
        return this.pluginCount;
    }

    @JsonIgnore
    public Iterable<ApplicationVersion> getVersions() {
        return ImmutableList.copyOf(this.versions);
    }

    @JsonIgnore
    public Iterable<String> getCategories() {
        return ImmutableList.copyOf(this.categories);
    }
}

