/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.marketplace.client.impl;

import com.atlassian.marketplace.client.HttpConfiguration;
import com.atlassian.marketplace.client.MarketplaceClient;
import com.atlassian.marketplace.client.MpacException;
import com.atlassian.marketplace.client.RequestDecorator;
import com.atlassian.marketplace.client.impl.HttpHelper;
import com.atlassian.upm.api.util.Option;
import com.google.common.base.Preconditions;
import com.google.common.collect.Multimap;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.SocketException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Map;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpResponse;
import org.apache.http.auth.AuthScheme;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.NTCredentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.HttpClient;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.entity.ContentType;
import org.apache.http.impl.auth.BasicScheme;
import org.apache.http.impl.client.BasicAuthCache;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.client.cache.CacheConfig;
import org.apache.http.impl.client.cache.CachingHttpClient;
import org.apache.http.impl.conn.PoolingClientConnectionManager;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.params.BasicHttpParams;
import org.apache.http.params.HttpParams;
import org.apache.http.protocol.BasicHttpContext;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CommonsHttpHelper
implements HttpHelper {
    private static final Logger logger = LoggerFactory.getLogger(MarketplaceClient.class);
    private final HttpClient client;
    private final HttpConfiguration config;
    private final RequestDecorator requestDecorator;

    public CommonsHttpHelper(HttpConfiguration configuration, URI baseUri) {
        this.config = (HttpConfiguration)Preconditions.checkNotNull((Object)configuration, (Object)"configuration");
        this.client = CommonsHttpHelper.createCachingHttpClient(this.config, baseUri);
        this.requestDecorator = configuration.getRequestDecorator();
    }

    @Override
    public HttpHelper.Response get(URI uri) throws MpacException {
        HttpGet method = new HttpGet(uri);
        this.configureMethod((HttpUriRequest)method);
        return new ResponseImpl(this.executeMethod((HttpUriRequest)method));
    }

    @Override
    public HttpHelper.Response postParams(URI uri, Multimap<String, String> params) throws MpacException {
        HttpPost method = new HttpPost(uri);
        this.configureMethod((HttpUriRequest)method);
        ArrayList<BasicNameValuePair> formParams = new ArrayList<BasicNameValuePair>();
        for (Map.Entry param : params.entries()) {
            formParams.add(new BasicNameValuePair((String)param.getKey(), (String)param.getValue()));
        }
        try {
            method.setEntity((HttpEntity)new UrlEncodedFormEntity(formParams));
        }
        catch (UnsupportedEncodingException e) {
            throw new MpacException(e);
        }
        return new ResponseImpl(this.executeMethod((HttpUriRequest)method));
    }

    @Override
    public HttpHelper.Response put(URI uri, byte[] content) throws MpacException {
        HttpPut method = new HttpPut(uri);
        this.configureMethod((HttpUriRequest)method);
        method.setEntity((HttpEntity)new ByteArrayEntity(content, ContentType.APPLICATION_JSON));
        return new ResponseImpl(this.executeMethod((HttpUriRequest)method));
    }

    @Override
    public HttpHelper.Response delete(URI uri) throws MpacException {
        HttpDelete method = new HttpDelete(uri);
        this.configureMethod((HttpUriRequest)method);
        return new ResponseImpl(this.executeMethod((HttpUriRequest)method));
    }

    private void configureMethod(HttpUriRequest method) {
        if (this.requestDecorator != null) {
            for (Map.Entry<String, String> header : this.requestDecorator.getRequestHeaders().entrySet()) {
                method.addHeader(header.getKey(), header.getValue());
            }
        }
    }

    private HttpResponse executeMethod(HttpUriRequest method) throws MpacException {
        logger.info(method.getMethod() + " " + method.getURI());
        try {
            return this.client.execute(method, this.createRequestContext(method));
        }
        catch (SocketException e) {
            throw new MpacException.ConnectionFailure(e);
        }
        catch (IOException e) {
            throw new MpacException(e);
        }
    }

    private HttpContext createRequestContext(HttpUriRequest method) {
        BasicHttpContext ctx = new BasicHttpContext();
        if (this.config.hasCredentials()) {
            BasicAuthCache authCache = new BasicAuthCache();
            authCache.put(new HttpHost(method.getURI().getHost(), method.getURI().getPort(), method.getURI().getScheme()), (AuthScheme)new BasicScheme());
            ctx.setAttribute("http.auth.auth-cache", (Object)authCache);
        }
        return ctx;
    }

    private static HttpClient createCachingHttpClient(HttpConfiguration config, URI baseUri) {
        DefaultHttpClient realClient = CommonsHttpHelper.createHttpClient(config, (Option<URI>)Option.some((Object)baseUri));
        CacheConfig cacheConfig = new CacheConfig();
        cacheConfig.setSharedCache(false);
        cacheConfig.setMaxCacheEntries(config.getMaxCacheEntries());
        cacheConfig.setMaxObjectSize(config.getMaxCacheObjectSize());
        CachingHttpClient cachingClient = new CachingHttpClient((HttpClient)realClient, cacheConfig);
        return cachingClient;
    }

    public static DefaultHttpClient createHttpClient(HttpConfiguration config, Option<URI> baseUri) {
        PoolingClientConnectionManager httpConnectionManager = new PoolingClientConnectionManager();
        httpConnectionManager.setDefaultMaxPerRoute(config.getMaxConnections());
        BasicHttpParams httpParams = new BasicHttpParams();
        httpParams.setIntParameter("http.connection.timeout", config.getConnectTimeoutMillis());
        httpParams.setIntParameter("http.socket.timeout", config.getReadTimeoutMillis());
        httpParams.setParameter("http.protocol.cookie-policy", (Object)"ignoreCookies");
        DefaultHttpClient httpClient = new DefaultHttpClient((ClientConnectionManager)httpConnectionManager, (HttpParams)httpParams);
        if (config.hasCredentials()) {
            for (URI uri : baseUri) {
                httpClient.getCredentialsProvider().setCredentials(new AuthScope(uri.getHost(), uri.getPort()), (Credentials)new UsernamePasswordCredentials(config.getUsername(), config.getPassword()));
            }
        }
        if (config.hasProxy()) {
            HttpConfiguration.ProxyConfiguration proxy = config.getProxy();
            httpClient.getParams().setParameter("http.route.default-proxy", (Object)new HttpHost(proxy.getHost(), proxy.getPort().intValue()));
            if (proxy.hasAuth()) {
                UsernamePasswordCredentials proxyCredentials;
                AuthScope proxyAuthScope = new AuthScope(proxy.getHost(), proxy.getPort().intValue());
                switch (proxy.getAuthMethod()) {
                    case NTLM: {
                        proxyCredentials = new NTCredentials(proxy.getUsername(), proxy.getPassword(), proxy.getNtlmWorkstation() == null ? "" : proxy.getNtlmWorkstation(), proxy.getNtlmDomain() == null ? "" : proxy.getNtlmDomain());
                        break;
                    }
                    default: {
                        proxyCredentials = new UsernamePasswordCredentials(proxy.getUsername(), proxy.getPassword());
                    }
                }
                httpClient.getCredentialsProvider().setCredentials(proxyAuthScope, (Credentials)proxyCredentials);
            }
        }
        return httpClient;
    }

    private static class ResponseImpl
    implements HttpHelper.Response {
        private final HttpResponse response;

        ResponseImpl(HttpResponse response) {
            this.response = response;
        }

        @Override
        public int getStatus() {
            return this.response.getStatusLine().getStatusCode();
        }

        @Override
        public InputStream getContentStream() throws MpacException {
            try {
                return this.response.getEntity().getContent();
            }
            catch (IOException e) {
                throw new MpacException(e);
            }
        }

        @Override
        public boolean isEmpty() {
            Header h = this.response.getFirstHeader("Content-Length");
            return h != null && h.getValue().trim().equals("0");
        }

        @Override
        public void close() {
            if (this.response.getEntity() != null) {
                EntityUtils.consumeQuietly((HttpEntity)this.response.getEntity());
            }
        }
    }
}

