/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.marketplace.client.impl;

import com.atlassian.marketplace.client.MpacException;
import com.atlassian.marketplace.client.api.ApplicationKey;
import com.atlassian.marketplace.client.api.Categories;
import com.atlassian.marketplace.client.impl.DefaultMarketplaceClient;
import com.atlassian.marketplace.client.impl.representations.PluginCategoriesByAppRepresentation;
import com.atlassian.marketplace.client.impl.representations.RootRepresentation;
import com.atlassian.marketplace.client.model.PluginCategory;
import com.atlassian.marketplace.client.util.UriBuilder;
import com.google.common.collect.ImmutableList;
import java.net.URI;
import java.util.Collection;

final class CategoriesImpl
implements Categories {
    private final DefaultMarketplaceClient client;
    private final RootRepresentation root;

    CategoriesImpl(DefaultMarketplaceClient client, RootRepresentation root) {
        this.client = client;
        this.root = root;
    }

    @Override
    public Iterable<String> findAll() throws MpacException {
        return ImmutableList.copyOf((Iterable)this.client.getEntity(this.categoriesBaseUri().build(), Collection.class));
    }

    @Override
    public Iterable<PluginCategory> findForApplication(ApplicationKey appKey) throws MpacException {
        URI uri = this.categoriesBaseUri().path("app").path(this.client.urlEncode(appKey.getKey())).build();
        return this.client.getEntity(uri, PluginCategoriesByAppRepresentation.class).getCategories();
    }

    private UriBuilder categoriesBaseUri() throws MpacException {
        return UriBuilder.fromUri(this.client.requireLinkUri(this.root.getLinks(), "categories", this.root.getClass()));
    }
}

