/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.marketplace.client.api;

import com.atlassian.marketplace.client.api.ApplicationKey;
import com.atlassian.marketplace.client.api.PricingQuery;
import com.atlassian.marketplace.client.model.PluginSummary;
import com.atlassian.upm.api.util.Option;
import com.google.common.base.Preconditions;

public final class PluginDetailQuery {
    private final String pluginKey;
    private final Option<Version> version;
    private final Option<ApplicationKey> application;
    private final Option<Long> appBuildNumber;
    private final Option<PricingQuery> includePricing;
    private final Option<Integer> limitVersions;
    private final Option<Integer> limitReviews;

    public static Builder builder(String pluginKey) {
        return new Builder(pluginKey);
    }

    public static Builder builder(PluginSummary pluginSummary) {
        return PluginDetailQuery.builder(pluginSummary.getPluginKey());
    }

    private PluginDetailQuery(Builder builder) {
        this.pluginKey = builder.pluginKey;
        this.version = builder.version;
        this.application = builder.application;
        this.appBuildNumber = builder.appBuildNumber;
        this.includePricing = builder.includePricing;
        this.limitVersions = builder.limitVersions;
        this.limitReviews = builder.limitReviews;
    }

    public String getPluginKey() {
        return this.pluginKey;
    }

    public Option<Version> getVersion() {
        return this.version;
    }

    public Option<ApplicationKey> getApplication() {
        return this.application;
    }

    public Option<Long> getAppBuildNumber() {
        return this.appBuildNumber;
    }

    public Option<PricingQuery> getIncludePricing() {
        return this.includePricing;
    }

    public Option<Integer> getLimitVersions() {
        return this.limitVersions;
    }

    public Option<Integer> getLimitReviews() {
        return this.limitReviews;
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("PluginDetailQuery(").append(this.pluginKey);
        for (Version v : this.version) {
            b.append(", version(").append(v.toString()).append(")");
        }
        for (ApplicationKey a : this.application) {
            b.append(", application(").append(a.getKey()).append(")");
        }
        for (Long ab : this.appBuildNumber) {
            b.append(", appBuildNumber(").append(ab).append(")");
        }
        for (PricingQuery pq : this.includePricing) {
            b.append(", pricing(").append(pq).append(")");
        }
        for (Integer lv : this.limitVersions) {
            b.append(", limitVersions(").append(lv).append(")");
        }
        for (Integer lr : this.limitReviews) {
            b.append(", limitReviews(").append(lr).append(")");
        }
        return b.append(")").toString();
    }

    public boolean equals(Object other) {
        return other instanceof PluginDetailQuery ? this.toString().equals(other.toString()) : false;
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public static class Builder {
        private final String pluginKey;
        private Option<Version> version = Option.none();
        private Option<ApplicationKey> application = Option.none();
        private Option<Long> appBuildNumber = Option.none();
        private Option<PricingQuery> includePricing = Option.none();
        private Option<Integer> limitVersions = Option.none();
        private Option<Integer> limitReviews = Option.some((Object)0);

        public Builder(String pluginKey) {
            this.pluginKey = (String)Preconditions.checkNotNull((Object)pluginKey, (Object)"pluginKey");
        }

        public PluginDetailQuery build() {
            return new PluginDetailQuery(this);
        }

        public Builder version(Option<Version> version) {
            this.version = (Option)Preconditions.checkNotNull(version);
            return this;
        }

        public Builder application(Option<ApplicationKey> application) {
            this.application = (Option)Preconditions.checkNotNull(application);
            return this;
        }

        public Builder appBuildNumber(Option<Long> appBuildNumber) {
            this.appBuildNumber = (Option)Preconditions.checkNotNull(appBuildNumber);
            return this;
        }

        public Builder includePricing(Option<PricingQuery> includePricing) {
            this.includePricing = (Option)Preconditions.checkNotNull(includePricing);
            return this;
        }

        public Builder limitVersions(Option<Integer> limitVersions) {
            this.limitVersions = (Option)Preconditions.checkNotNull(limitVersions);
            return this;
        }

        public Builder limitReviews(Option<Integer> limitReviews) {
            this.limitReviews = (Option)Preconditions.checkNotNull(limitReviews);
            return this;
        }
    }

    public static final class Version {
        private final String version;
        private final boolean greaterThan;

        private Version(String version, boolean greaterThan) {
            this.version = (String)Preconditions.checkNotNull((Object)version);
            this.greaterThan = greaterThan;
        }

        public static Version equalTo(String version) {
            return new Version(version, false);
        }

        public static Version greaterThan(String version) {
            return new Version(version, true);
        }

        public String getVersion() {
            return this.version;
        }

        public boolean isGreaterThan() {
            return this.greaterThan;
        }

        public String toString() {
            return (this.greaterThan ? "> " : "== ") + this.version;
        }

        public boolean equals(Object other) {
            return other instanceof Version ? this.toString().equals(other.toString()) : false;
        }

        public int hashCode() {
            return this.toString().hashCode();
        }
    }
}

