/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.marketplace.client.api;

import com.atlassian.marketplace.client.api.PageReference;
import com.atlassian.upm.api.util.Option;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.util.Iterator;

public abstract class Page<T>
implements Iterable<T> {
    private final ImmutableList<T> items;
    private final int totalSize;
    private static final Page<Object> EMPTY_PAGE = new FixedPage<Object>((Iterable<Object>)ImmutableList.of());

    public static <T> Page<T> empty() {
        return EMPTY_PAGE;
    }

    public static <T> Page<T> empty(Class<T> type) {
        return EMPTY_PAGE;
    }

    public static <T> Page<T> fromItems(Iterable<T> items) {
        return Iterables.isEmpty(items) ? Page.empty() : new FixedPage<T>(items);
    }

    protected Page(Iterable<T> items, int totalSize) {
        this.items = ImmutableList.copyOf((Iterable)((Iterable)Preconditions.checkNotNull(items, (Object)"items")));
        this.totalSize = totalSize;
    }

    @Override
    public Iterator<T> iterator() {
        return this.items.iterator();
    }

    public int size() {
        return this.items.size();
    }

    public int totalSize() {
        return this.totalSize;
    }

    public abstract Option<PageReference<T>> getReference();

    public abstract Option<PageReference<T>> getPrevious();

    public abstract Option<PageReference<T>> getNext();

    public int getOffset() {
        Iterator i$ = this.getReference().iterator();
        if (i$.hasNext()) {
            PageReference ref = (PageReference)i$.next();
            return ref.getOffset();
        }
        return 0;
    }

    private static final class FixedPage<T>
    extends Page<T> {
        FixedPage(Iterable<T> items) {
            super(ImmutableList.copyOf(items), Iterables.size(items));
        }

        @Override
        public Option<PageReference<T>> getReference() {
            return Option.none();
        }

        @Override
        public Option<PageReference<T>> getPrevious() {
            return Option.none();
        }

        @Override
        public Option<PageReference<T>> getNext() {
            return Option.none();
        }
    }
}

