/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.marketplace.client.api;

import com.atlassian.marketplace.client.api.ApplicationKey;
import com.atlassian.upm.api.util.Option;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.Iterator;

public final class BannerQuery {
    private final Option<ApplicationKey> application;
    private final Option<Long> appBuildNumber;
    private final Option<String> label;
    private final int offset;
    private final Option<Integer> limit;

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(BannerQuery query) {
        return BannerQuery.builder().application(query.getApplication()).appBuildNumber(query.getAppBuildNumber()).label(query.getLabel()).offset(query.getOffset()).limit(query.getLimit());
    }

    private BannerQuery(Builder builder) {
        this.application = builder.application;
        this.appBuildNumber = builder.appBuildNumber;
        this.label = builder.label;
        this.offset = builder.offset;
        this.limit = builder.limit;
    }

    public Option<ApplicationKey> getApplication() {
        return this.application;
    }

    public Option<Long> getAppBuildNumber() {
        return this.appBuildNumber;
    }

    public Option<String> getLabel() {
        return this.label;
    }

    public int getOffset() {
        return this.offset;
    }

    public Option<Integer> getLimit() {
        return this.limit;
    }

    public String toString() {
        ImmutableList.Builder params = ImmutableList.builder();
        for (ApplicationKey a : this.application) {
            params.add((Object)("application(" + a.getKey() + ")"));
        }
        for (Long ab : this.appBuildNumber) {
            params.add((Object)("appBuildNumber(" + ab + ")"));
        }
        for (Object l : this.label) {
            params.add((Object)("label(" + (String)l + ")"));
        }
        if (this.offset > 0) {
            params.add((Object)("offset(" + this.offset + ")"));
        }
        for (Object l : this.limit) {
            params.add((Object)("limit(" + l + ")"));
        }
        return "PluginQuery(" + Joiner.on((String)", ").join((Iterable)params.build()) + ")";
    }

    public boolean equals(Object other) {
        return other instanceof BannerQuery ? this.toString().equals(other.toString()) : false;
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public static class Builder {
        private Option<ApplicationKey> application = Option.none();
        private Option<Long> appBuildNumber = Option.none();
        private Option<String> label = Option.none();
        private int offset = 0;
        private Option<Integer> limit = Option.none();

        public BannerQuery build() {
            return new BannerQuery(this);
        }

        public Builder application(Option<ApplicationKey> application) {
            this.application = (Option)Preconditions.checkNotNull(application);
            return this;
        }

        public Builder appBuildNumber(Option<Long> appBuildNumber) {
            this.appBuildNumber = (Option)Preconditions.checkNotNull(appBuildNumber);
            return this;
        }

        public Builder label(Option<String> label) {
            this.label = label;
            return this;
        }

        public Builder offset(int offset) {
            if (offset < 0) {
                throw new IllegalArgumentException("offset may not be negative");
            }
            this.offset = offset;
            return this;
        }

        public Builder limit(Option<Integer> limit) {
            Iterator i$ = limit.iterator();
            while (i$.hasNext()) {
                int l = (Integer)i$.next();
                if (l >= 0) continue;
                throw new IllegalArgumentException("limit may not be negative");
            }
            this.limit = limit;
            return this;
        }
    }
}

