package com.atlassian.marketplace.client.model;

import java.util.Date;

import com.atlassian.upm.api.util.Option;

import org.codehaus.jackson.annotate.JsonCreator;
import org.codehaus.jackson.annotate.JsonIgnore;
import org.codehaus.jackson.annotate.JsonProperty;

import static com.atlassian.marketplace.client.util.ModelUtil.requireProperty;
import static com.atlassian.upm.api.util.Option.option;

/**
 * A user review for a plugin.
 */
public final class Review
{
    @JsonProperty private final Links links;
    @JsonProperty private final String pluginName;
    @JsonProperty private final UserSummary author;
    @JsonProperty private final int stars;
    @JsonProperty private final Date date;
    @JsonProperty private final String review;
    @JsonProperty private final ReviewResponse response;
    
    @JsonCreator
    Review(@JsonProperty("links") Links links,
           @JsonProperty("pluginName") String pluginName,
           @JsonProperty("author") UserSummary author,
           @JsonProperty("stars") Integer stars,
           @JsonProperty("date") Date date,
           @JsonProperty("review") String review,
           @JsonProperty("response") ReviewResponse response)
    {
        this.links = requireProperty(links, "links");
        this.pluginName = requireProperty(pluginName, "pluginName");
        this.author = author;  // optional
        this.stars = requireProperty(stars, "stars");
        this.date = requireProperty(date, "date");
        this.review = review;  // optional
        this.response = response;  // optional
    }

    public Links getLinks()
    {
        return links;
    }

    /**
     * Name of the plugin being reviewed.
     */
    public String getPluginName()
    {
        return pluginName;
    }

    /**
     * Optional information about the reviewer.
     */
    @JsonIgnore
    public Option<UserSummary> getAuthor()
    {
        return option(author);
    }

    /**
     * The number of stars for the review (1=worst, 5=best).
     */
    public int getStars()
    {
        return stars;
    }

    /**
     * The date on which the review was posted.
     */
    public Date getDate()
    {
        return date;
    }

    /**
     * The review text, if any.
     */
    @JsonIgnore
    public Option<String> getReview()
    {
        return option(review);
    }

    /**
     * The vendor's response, if any.
     */
    @JsonIgnore
    public Option<ReviewResponse> getResponse()
    {
        return option(response);
    }    
}
