package com.atlassian.marketplace.client.model;

import org.codehaus.jackson.annotate.JsonCreator;
import org.codehaus.jackson.annotate.JsonProperty;

import static com.atlassian.marketplace.client.util.ModelUtil.requireProperty;

/**
 * A category that contains some subset of plugins, such as Macros.
 */
public final class PluginCategory
{
    @JsonProperty private final Links links;
    @JsonProperty private final String name;
    
    @JsonCreator
    PluginCategory(@JsonProperty("links") Links links,
                   @JsonProperty("name") String name)
    {
        this.links = requireProperty(links, "links");
        this.name = requireProperty(name, "name");
    }

    public Links getLinks()
    {
        return links;
    }

    /**
     * The category name.
     */
    public String getName()
    {
        return name;
    }
}
