package com.atlassian.marketplace.client.model;

import org.codehaus.jackson.annotate.JsonCreator;
import org.codehaus.jackson.annotate.JsonProperty;

import static com.atlassian.marketplace.client.util.ModelUtil.requireProperty;

/**
 * Information about the kind of license associated with a plugin.
 */
public final class LicenseType
{
    @JsonProperty private final Links links;
    @JsonProperty private final String id;
    @JsonProperty private final String name;
    
    @JsonCreator
    LicenseType(@JsonProperty("links") Links links,
                @JsonProperty("id") String id,
                @JsonProperty("name") String name)
    {
        this.links = requireProperty(links, "links");
        this.id = requireProperty(id, "id");
        this.name = requireProperty(name, "name");
    }

    public Links getLinks()
    {
        return links;
    }

    /**
     * A unique identifier for this license type.
     */
    public String getId()
    {
        return id;
    }

    /**
     * Human-readable name of the license type (e.g. "BSD").
     */
    public String getName()
    {
        return name;
    }    
}
