package com.atlassian.marketplace.client.model;

import java.net.URI;

import com.atlassian.upm.api.util.Option;

import org.codehaus.jackson.annotate.JsonCreator;
import org.codehaus.jackson.annotate.JsonIgnore;
import org.codehaus.jackson.annotate.JsonProperty;

import static com.atlassian.marketplace.client.util.ModelUtil.requireLink;
import static com.atlassian.marketplace.client.util.ModelUtil.requireProperty;
import static com.atlassian.upm.api.util.Option.option;

/**
 * Information about an image resource.
 */
public final class Image
{
    @JsonProperty private final Links links;
    private final URI binaryUri;
    @JsonProperty private final int width;
    @JsonProperty private final int height;
    @JsonProperty private final String altText;
    
    @JsonCreator
    Image(@JsonProperty("links") Links links,
          @JsonProperty("width") Integer width,
          @JsonProperty("height") Integer height,
          @JsonProperty("altText") String altText)
    {
        this.links = requireProperty(links, "links");
        this.binaryUri = requireLink(links, "binary");
        this.width = requireProperty(width, "width");
        this.height = requireProperty(height, "height");
        this.altText = altText;  // optional
    }

    public Links getLinks()
    {
        return links;
    }

    /**
     * The URL of the image itself.
     */
    @JsonIgnore
    public URI getImageUri()
    {
        return binaryUri;
    }
    
    /**
     * The width in pixels.
     */
    public int getWidth()
    {
        return width;
    }

    /**
     * The height in pixels.
     */
    public int getHeight()
    {
        return height;
    }

    /**
     * The image content type, if specified.
     */
    @JsonIgnore
    public Option<String> getImageContentType()
    {
        return links.getContentType("binary");
    }

    /**
     * The alternate text for the image, if any.
     */
    @JsonIgnore
    public Option<String> getAltText()
    {
        return option(altText);
    }
}
