package com.atlassian.marketplace.client.model;

import com.atlassian.upm.api.util.Option;

import org.codehaus.jackson.annotate.JsonCreator;
import org.codehaus.jackson.annotate.JsonIgnore;
import org.codehaus.jackson.annotate.JsonProperty;

import static com.atlassian.upm.api.util.Option.option;

/**
 * Information about icons associated with a plugin or a vendor.
 */
public final class Icons
{
    @JsonProperty("default") private final Image defaultIcon;
    @JsonProperty("tiny") private final Image tinyIcon;
    
    @JsonCreator
    Icons(@JsonProperty("default") Image defaultIcon,
          @JsonProperty("tiny") Image tinyIcon)
    {
        this.defaultIcon = defaultIcon;  // optional
        this.tinyIcon = tinyIcon;  // optional
    }
    
    /**
     * The full-sized icon.
     */
    @JsonIgnore
    public Option<Image> getDefaultIcon()
    {
        return option(defaultIcon);
    }
    
    /**
     * The small icon (16x16).
     */
    public Option<Image> getTinyIcon()
    {
        return option(tinyIcon);
    }
}
