package com.atlassian.marketplace.client.model;

import com.atlassian.marketplace.client.api.ApplicationKey;

import org.codehaus.jackson.annotate.JsonCreator;
import org.codehaus.jackson.annotate.JsonProperty;

import static com.atlassian.marketplace.client.util.ModelUtil.requireProperty;

/**
 * Abbreviated information about an Atlassian application.
 */
public final class ApplicationSummary
{
    @JsonProperty private final Links links;
    @JsonProperty private final String key;
    @JsonProperty private final String name;
    @JsonProperty private final int order;
    @JsonProperty private final int pluginCount;
    
    // fields omitted: status
    
    @JsonCreator
    ApplicationSummary(@JsonProperty("links") Links links,
                       @JsonProperty("key") String key,
                       @JsonProperty("name") String name,
                       @JsonProperty("order") Integer order,
                       @JsonProperty("pluginCount") Integer pluginCount)
    {
        this.links = requireProperty(links, "links");
        this.key = requireProperty(key, "key");
        this.name = requireProperty(name, "name");
        this.order = requireProperty(order, "order");
        this.pluginCount = requireProperty(pluginCount, "pluginCount");
    }

    public Links getLinks()
    {
        return links;
    }

    /**
     * The short unique identifier for the application.
     * @JsonIgnore
     */
    public ApplicationKey getKey()
    {
        return ApplicationKey.valueOf(key);
    }

    /**
     * The application name.
     */
    public String getName()
    {
        return name;
    }

    /**
     * The order in which this application is listed on the Marketplace.
     */
    public int getOrder()
    {
        return order;
    }

    /**
     * The total number of published plugins that are compatible with this application.
     */
    public int getPluginCount()
    {
        return pluginCount;
    }
}
