package com.atlassian.marketplace.client.impl.representations;

import java.util.Collection;

import com.atlassian.marketplace.client.model.ApplicationSummary;
import com.atlassian.marketplace.client.model.Links;

import com.google.common.collect.ImmutableList;

import org.codehaus.jackson.annotate.JsonCreator;
import org.codehaus.jackson.annotate.JsonIgnore;
import org.codehaus.jackson.annotate.JsonProperty;

import static com.atlassian.marketplace.client.util.ModelUtil.requireList;
import static com.atlassian.marketplace.client.util.ModelUtil.requireProperty;

/**
 * Entity returned by the /plugins/applications resource.
 */
public final class ApplicationsRepresentation
{
    @JsonProperty private final Links links;
    @JsonProperty private final Collection<ApplicationSummary> applications;

    @JsonCreator
    public ApplicationsRepresentation(@JsonProperty("links") Links links,
                                      @JsonProperty("applications") Collection<ApplicationSummary> applications)
    {
        this.links = requireProperty(links, "links");
        this.applications = requireList(applications, "applications");
    }
    
    public Links getLinks()
    {
        return links;
    }
    
    @JsonIgnore
    public Iterable<ApplicationSummary> getApplications()
    {
        return ImmutableList.copyOf(applications);
    }
}
