package com.atlassian.marketplace.client.api;

import java.net.URI;

import com.atlassian.upm.api.util.Option;

import static com.google.common.base.Preconditions.checkNotNull;

/**
 * Abstraction of the URI of a set of query results that can be pulled from the server.
 * @see Page
 */
public final class PageReference<T>
{
    private final URI uri;
    private final int offset;
    private final Option<Integer> limit;
    
    public PageReference(URI uri, int offset, Option<Integer> limit)
    {
        this.uri = checkNotNull(uri);
        this.offset = offset;
        this.limit = checkNotNull(limit);
    }
    
    /**
     * The REST URI of the result page.
     */
    public URI getUri()
    {
        return uri;
    }
    
    /**
     * The starting offset of the result page.
     */
    public int getOffset()
    {
        return offset;
    }
    
    /**
     * The maximum size of the result page.
     */
    public Option<Integer> getLimit()
    {
        return limit;
    }
    
    @SuppressWarnings("unchecked")
    @Override
    public boolean equals(Object other)
    {
        if (other instanceof PageReference)
        {
            PageReference<T> p = (PageReference<T>) other;
            return uri.equals(p.uri)&& (offset == p.offset) && limit.equals(p.limit); 
        }
        return false;
    }
    
    @Override
    public int hashCode()
    {
        return uri.hashCode();
    }
}
