package com.atlassian.marketplace.client.api;

import com.atlassian.marketplace.client.MpacException;
import com.atlassian.marketplace.client.model.PluginCategory;

/**
 * Starting point for all resources that return plugin information.
 */
public interface Categories
{
    /**
     * Returns the list of all categories.
     * @return the list of all categories
     * @throws MpacException  if the server was unavailable or returned an error
     */
    Iterable<String> findAll() throws MpacException;

    /**
     * Returns the list of all categories in which there are plugins compatible with the
     * specified application.
     * @param appKey an {@link ApplicationKey}
     * @return the list of categories
     * @throws MpacException  if the server was unavailable or returned an error
     */
    Iterable<PluginCategory> findForApplication(ApplicationKey appKey) throws MpacException;
}
