package com.atlassian.marketplace.client;

import java.net.SocketException;

/**
 * Base class for all exceptions thrown by {@link MarketplaceClient}.
 */
@SuppressWarnings("serial")
public class MpacException extends Exception
{
    public MpacException()
    {
        super();
    }
    
    public MpacException(String message)
    {
        super(message);
    }
    
    public MpacException(Throwable cause)
    {
        super(cause);
    }
    
    /**
     * Indicates that the client was unable to make an HTTP connection to the server, or that
     * a request timed out before a response was received.
     */
    public static class ConnectionFailure extends MpacException
    {
        public ConnectionFailure(SocketException e)
        {
            super(e);
        }
    }

    /**
     * Indicates that the server returned an HTTP error status code.
     */
    public static class ServerError extends MpacException
    {
        private final int status;
        
        public ServerError(int status)
        {
            super(String.valueOf(status));
            this.status = status;
        }
        
        public int getStatus()
        {
            return status;
        }
    }

    /**
     * Indicates that the server returned a response that could not be parsed.
     */
    public static class InvalidResponseError extends MpacException
    {
        public InvalidResponseError(String message)
        {
            super(message);
        }
    }
}
