/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.upm.spi;

import com.atlassian.upm.api.util.Option;
import com.atlassian.upm.api.util.Pair;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Iterator;

public class PluginInstallException
extends RuntimeException {
    private final Option<Pair<String, Serializable[]>> i18nMessage;
    private final boolean stackTraceSignificant;

    public PluginInstallException(String message) {
        this(message, true);
    }

    public PluginInstallException(String message, boolean stackTraceSignificant) {
        this(message, Option.none(String.class), stackTraceSignificant);
    }

    public PluginInstallException(String message, Throwable cause) {
        this(message, cause, true);
    }

    public PluginInstallException(String message, Throwable cause, boolean stackTraceSignificant) {
        super(message, cause);
        this.i18nMessage = Option.none();
        this.stackTraceSignificant = stackTraceSignificant;
    }

    public PluginInstallException(String message, Option<String> code) {
        this(message, code, true);
    }

    public PluginInstallException(String message, String code, Serializable ... params) {
        super(message);
        this.i18nMessage = Option.some(Pair.pair(Preconditions.checkNotNull((Object)code), Arrays.copyOf(params, params.length)));
        this.stackTraceSignificant = true;
    }

    public PluginInstallException(String message, Option<String> code, boolean stackTraceSignificant) {
        super(message);
        this.i18nMessage = ((Option)Preconditions.checkNotNull(code)).map(new Function<String, Pair<String, Serializable[]>>(){

            public Pair<String, Serializable[]> apply(String i18nKey) {
                return Pair.pair(i18nKey, new Serializable[0]);
            }
        });
        this.stackTraceSignificant = stackTraceSignificant;
    }

    public PluginInstallException(String message, Option<String> code, Throwable cause, boolean stackTraceSignificant) {
        super(message, cause);
        this.i18nMessage = ((Option)Preconditions.checkNotNull(code)).map(new Function<String, Pair<String, Serializable[]>>(){

            public Pair<String, Serializable[]> apply(String i18nKey) {
                return Pair.pair(i18nKey, new Serializable[0]);
            }
        });
        this.stackTraceSignificant = stackTraceSignificant;
    }

    public Option<String> getCode() {
        Iterator<Pair<String, Serializable[]>> iterator = this.i18nMessage.iterator();
        if (iterator.hasNext()) {
            Pair<String, Serializable[]> i18n = iterator.next();
            return Option.some(i18n.first());
        }
        return Option.none();
    }

    public Option<Pair<String, Serializable[]>> getI18nMessageProperties() {
        return this.i18nMessage;
    }

    public boolean isStackTraceSignificant() {
        return this.stackTraceSignificant;
    }
}

