/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.upm.rest.resources.updateall;

import com.atlassian.sal.api.user.UserManager;
import com.atlassian.upm.UpmInformation;
import com.atlassian.upm.api.license.HostLicenseInformation;
import com.atlassian.upm.core.PluginDownloadService;
import com.atlassian.upm.core.PluginInstallationService;
import com.atlassian.upm.core.PluginMetadataAccessor;
import com.atlassian.upm.core.PluginRetriever;
import com.atlassian.upm.core.SafeModeAccessor;
import com.atlassian.upm.core.async.AsyncTaskInfo;
import com.atlassian.upm.core.async.AsynchronousTaskManager;
import com.atlassian.upm.core.impl.UpmAppManager;
import com.atlassian.upm.core.log.AuditLogService;
import com.atlassian.upm.core.permission.Permission;
import com.atlassian.upm.core.rest.async.AsyncTaskRepresentationFactory;
import com.atlassian.upm.core.rest.resources.UpmResources;
import com.atlassian.upm.core.rest.resources.permission.PermissionEnforcer;
import com.atlassian.upm.core.token.TokenManager;
import com.atlassian.upm.license.internal.PluginLicenseRepository;
import com.atlassian.upm.license.internal.impl.role.RoleBasedLicensingPluginService;
import com.atlassian.upm.pac.PacClient;
import com.atlassian.upm.rest.UpmUriBuilder;
import com.atlassian.upm.rest.representations.UpmLinkBuilder;
import com.atlassian.upm.rest.representations.UpmRepresentationFactory;
import com.atlassian.upm.rest.resources.updateall.UpdateAllTask;
import com.atlassian.upm.schedule.UpmScheduler;
import com.google.common.base.Preconditions;
import javax.ws.rs.Consumes;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;

@Path(value="/updates/all")
public class UpdateAllResource {
    private final AsynchronousTaskManager taskManager;
    private final PacClient pacClient;
    private final PluginInstallationService pluginInstaller;
    private final UpmRepresentationFactory representationFactory;
    private final PluginRetriever pluginRetriever;
    private final PluginMetadataAccessor metadata;
    private final PluginDownloadService pluginDownloadService;
    private final PermissionEnforcer permissionEnforcer;
    private final AuditLogService auditLogger;
    private final UpmLinkBuilder linkBuilder;
    private final UpmUriBuilder uriBuilder;
    private final UserManager userManager;
    private final TokenManager tokenManager;
    private final PluginLicenseRepository licenseRepository;
    private final UpmScheduler upmScheduler;
    private final UpmInformation upm;
    private final SafeModeAccessor safeMode;
    private final RoleBasedLicensingPluginService roleBasedLicensingService;
    private final AsyncTaskRepresentationFactory taskRepresentationFactory;
    private final UpmAppManager appManager;
    private final HostLicenseInformation hostLicenseInformation;

    public UpdateAllResource(PluginRetriever pluginRetriever, PluginMetadataAccessor metadata, AsynchronousTaskManager taskManager, PacClient pacClient, PluginDownloadService pluginDownloadService, PluginInstallationService pluginInstaller, UpmRepresentationFactory representationFactory, PermissionEnforcer permissionEnforcer, AuditLogService auditLogger, UpmLinkBuilder linkBuilder, UpmUriBuilder uriBuilder, UserManager userManager, TokenManager tokenManager, PluginLicenseRepository licenseRepository, UpmScheduler upmScheduler, UpmInformation upm, SafeModeAccessor safeMode, RoleBasedLicensingPluginService roleBasedLicensingService, AsyncTaskRepresentationFactory taskRepresentationFactory, UpmAppManager appManager, HostLicenseInformation hostLicenseInformation) {
        this.userManager = (UserManager)Preconditions.checkNotNull((Object)userManager, (Object)"userManager");
        this.tokenManager = (TokenManager)Preconditions.checkNotNull((Object)tokenManager, (Object)"tokenManager");
        this.linkBuilder = (UpmLinkBuilder)Preconditions.checkNotNull((Object)linkBuilder, (Object)"linkBuilder");
        this.uriBuilder = (UpmUriBuilder)Preconditions.checkNotNull((Object)uriBuilder, (Object)"uriBuilder");
        this.permissionEnforcer = (PermissionEnforcer)Preconditions.checkNotNull((Object)permissionEnforcer, (Object)"permissionEnforcer");
        this.pluginRetriever = (PluginRetriever)Preconditions.checkNotNull((Object)pluginRetriever, (Object)"pluginRetriever");
        this.metadata = (PluginMetadataAccessor)Preconditions.checkNotNull((Object)metadata, (Object)"metadata");
        this.taskManager = (AsynchronousTaskManager)Preconditions.checkNotNull((Object)taskManager, (Object)"taskManager");
        this.pacClient = (PacClient)Preconditions.checkNotNull((Object)pacClient, (Object)"pacClient");
        this.pluginDownloadService = (PluginDownloadService)Preconditions.checkNotNull((Object)pluginDownloadService, (Object)"pluginDownloadService");
        this.pluginInstaller = (PluginInstallationService)Preconditions.checkNotNull((Object)pluginInstaller, (Object)"pluginInstaller");
        this.representationFactory = (UpmRepresentationFactory)Preconditions.checkNotNull((Object)representationFactory, (Object)"representationFactory");
        this.auditLogger = (AuditLogService)Preconditions.checkNotNull((Object)auditLogger, (Object)"auditLogger");
        this.licenseRepository = (PluginLicenseRepository)Preconditions.checkNotNull((Object)licenseRepository, (Object)"licenseRepository");
        this.upmScheduler = (UpmScheduler)Preconditions.checkNotNull((Object)upmScheduler, (Object)"upmScheduler");
        this.upm = (UpmInformation)Preconditions.checkNotNull((Object)upm, (Object)"upm");
        this.safeMode = (SafeModeAccessor)Preconditions.checkNotNull((Object)safeMode, (Object)"safeMode");
        this.roleBasedLicensingService = (RoleBasedLicensingPluginService)Preconditions.checkNotNull((Object)roleBasedLicensingService, (Object)"roleBasedLicensingService");
        this.taskRepresentationFactory = (AsyncTaskRepresentationFactory)Preconditions.checkNotNull((Object)taskRepresentationFactory, (Object)"taskRepresentationFactory");
        this.appManager = (UpmAppManager)Preconditions.checkNotNull((Object)appManager, (Object)"appManager");
        this.hostLicenseInformation = (HostLicenseInformation)Preconditions.checkNotNull((Object)hostLicenseInformation, (Object)"hostLicenseInformation");
    }

    @POST
    @Consumes(value={"application/vnd.atl.plugins.updateall+json"})
    public Response updateAll(@QueryParam(value="token") String token) {
        this.permissionEnforcer.enforcePermission(Permission.MANAGE_IN_PROCESS_PLUGIN_INSTALL_FROM_URI);
        UpmResources.validateToken(token, this.userManager.getRemoteUserKey(), "application/json", this.tokenManager, this.representationFactory);
        if (this.safeMode.isSafeMode()) {
            return Response.status((Response.Status)Response.Status.CONFLICT).entity((Object)this.representationFactory.createI18nErrorRepresentation("upm.update.error.safe.mode")).type("application/vnd.atl.plugins.task.error+json").build();
        }
        UpdateAllTask task = new UpdateAllTask(this.pacClient, this.permissionEnforcer, this.pluginDownloadService, this.pluginRetriever, this.metadata, this.pluginInstaller, this.upmScheduler, this.auditLogger, this.linkBuilder, this.uriBuilder, this.licenseRepository, this.roleBasedLicensingService, this.upm, this.appManager, this.hostLicenseInformation, this.userManager.getRemoteUserKey());
        AsyncTaskInfo taskInfo = this.taskManager.executeAsynchronousTask(task);
        return this.taskRepresentationFactory.createLegacyAsyncTaskRepresentation(taskInfo).toNewlyCreatedResponse(this.uriBuilder);
    }
}

