/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.upm.rest.resources.disableall;

import com.atlassian.marketplace.client.MpacException;
import com.atlassian.upm.MarketplacePlugins;
import com.atlassian.upm.UpmInformation;
import com.atlassian.upm.api.util.Option;
import com.atlassian.upm.core.PluginEnablementService;
import com.atlassian.upm.core.PluginRetriever;
import com.atlassian.upm.core.async.AsyncTask;
import com.atlassian.upm.core.async.AsyncTaskStage;
import com.atlassian.upm.core.async.AsyncTaskStatus;
import com.atlassian.upm.core.async.AsyncTaskStatusUpdater;
import com.atlassian.upm.core.async.AsyncTaskType;
import com.atlassian.upm.core.async.TaskSubitemFailure;
import com.atlassian.upm.core.async.TaskSubitemSuccess;
import com.atlassian.upm.pac.IncompatiblePluginData;
import com.atlassian.upm.pac.PacClient;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DisableAllIncompatibleTask
implements AsyncTask {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final PacClient pacClient;
    private final PluginEnablementService enabler;
    private final PluginRetriever pluginRetriever;
    private final UpmInformation upm;

    public DisableAllIncompatibleTask(PacClient pacClient, PluginEnablementService enabler, PluginRetriever pluginRetriever, UpmInformation upm) {
        this.pacClient = (PacClient)Preconditions.checkNotNull((Object)pacClient, (Object)"pacClient");
        this.upm = (UpmInformation)Preconditions.checkNotNull((Object)upm, (Object)"upm");
        this.enabler = (PluginEnablementService)Preconditions.checkNotNull((Object)enabler, (Object)"enabler");
        this.pluginRetriever = (PluginRetriever)Preconditions.checkNotNull((Object)pluginRetriever, (Object)"pluginRetriever");
    }

    @Override
    public AsyncTaskStatus getInitialStatus() {
        return AsyncTaskStatus.builder().stage(Option.some(AsyncTaskStage.FINDING)).build();
    }

    @Override
    public AsyncTaskType getType() {
        return AsyncTaskType.DISABLE_ALL_INCOMPATIBLE;
    }

    @Override
    public AsyncTaskStatus run(AsyncTaskStatusUpdater statusUpdater) throws Exception {
        try {
            return this.disable(this.findIncompatibles(), statusUpdater);
        }
        catch (MpacException pe) {
            this.logger.error("Failed to find incompatible plugins: " + pe);
            return AsyncTaskStatus.builder().errorByCode("err.finding.incompatibles").build();
        }
        catch (Throwable t) {
            this.logger.error("Failed to disable all incompatible plugins", t);
            return AsyncTaskStatus.builder().errorByCode("unexpected.exception").build();
        }
    }

    private Iterable<IncompatiblePluginData> findIncompatibles() throws MpacException {
        return Iterables.filter(this.pacClient.getIncompatiblePlugins((Iterable<String>)ImmutableList.of((Object)this.upm.getPluginKey())), (Predicate)Predicates.and(MarketplacePlugins.enabled(this.pluginRetriever), IncompatiblePluginData::isIncompatibleWithHostProduct));
    }

    static AsyncTaskStatus disabling(IncompatiblePluginData plugin, int numberComplete, int totalIncompatibles) {
        return AsyncTaskStatus.builder().stage(Option.some(AsyncTaskStage.APPLYING_ALL)).resourceName(Option.some(plugin.getName())).resourceVersion(Option.some(plugin.getVersion())).itemsDone(Option.some(numberComplete)).itemsTotal(Option.some(totalIncompatibles)).build();
    }

    private AsyncTaskStatus disable(Iterable<IncompatiblePluginData> incompatiblePlugins, AsyncTaskStatusUpdater statusUpdater) {
        ImmutableList.Builder successes = ImmutableList.builder();
        ImmutableList.Builder failures = ImmutableList.builder();
        int totalIncompatibles = Iterables.size(incompatiblePlugins);
        for (IncompatiblePluginData plugin : incompatiblePlugins) {
            try {
                int numberComplete = successes.build().size() + failures.build().size();
                statusUpdater.updateStatus(DisableAllIncompatibleTask.disabling(plugin, numberComplete, totalIncompatibles));
                boolean disabled = this.enabler.disablePlugin(plugin.getKey());
                if (disabled) {
                    successes.add((Object)new TaskSubitemSuccess(plugin.getName(), plugin.getKey(), plugin.getVersion(), null));
                    continue;
                }
                failures.add((Object)this.makeFailure("disable.failed", plugin));
            }
            catch (Exception e) {
                failures.add((Object)this.makeFailure("disable.error", plugin, e.getMessage()));
            }
        }
        return AsyncTaskStatus.builder().successes(Option.some(successes.build())).failures(Option.some(failures.build())).build();
    }

    private TaskSubitemFailure makeFailure(String errorCode, IncompatiblePluginData p) {
        return this.makeFailure(errorCode, p, null);
    }

    private TaskSubitemFailure makeFailure(String errorCode, IncompatiblePluginData p, String message) {
        return new TaskSubitemFailure((TaskSubitemFailure.Type)null, p.getName(), p.getKey(), p.getVersion(), errorCode, message, "");
    }
}

