/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.upm.rest.resources;

import com.atlassian.sal.api.websudo.WebSudoNotRequired;
import com.atlassian.upm.SysPersisted;
import com.atlassian.upm.UpmSettings;
import com.atlassian.upm.pac.PacClient;
import com.atlassian.upm.rest.UpmUriBuilder;
import com.atlassian.upm.rest.representations.UpmLinkBuilder;
import com.atlassian.upm.rest.representations.UpmRepresentationFactory;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.net.URI;
import java.util.Map;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.codehaus.jackson.annotate.JsonCreator;
import org.codehaus.jackson.annotate.JsonProperty;

@Path(value="/pac-status")
@WebSudoNotRequired
public class PacStatusResource {
    private final PacClient client;
    private final UpmRepresentationFactory factory;
    private final SysPersisted sysPersisted;

    public PacStatusResource(PacClient client, UpmRepresentationFactory factory, SysPersisted sysPersisted) {
        this.client = (PacClient)Preconditions.checkNotNull((Object)client, (Object)"client");
        this.factory = (UpmRepresentationFactory)Preconditions.checkNotNull((Object)factory, (Object)"factory");
        this.sysPersisted = (SysPersisted)Preconditions.checkNotNull((Object)sysPersisted, (Object)"sysPersisted");
    }

    @GET
    @Produces(value={"application/vnd.atl.plugins.pac.status+json"})
    public Response getPacStatus() {
        this.client.forgetPacReachableState(false);
        return Response.ok((Object)this.factory.createPacStatusRepresentation(this.sysPersisted.is(UpmSettings.PAC_DISABLED), this.client.isPacReachable())).build();
    }

    public static final class PacStatusRepresentation {
        @JsonProperty
        private boolean disabled;
        @JsonProperty
        private boolean reached;
        @JsonProperty
        private final Map<String, URI> links;

        @JsonCreator
        public PacStatusRepresentation(@JsonProperty(value="disabled") boolean disabled, @JsonProperty(value="reached") boolean reached, @JsonProperty(value="links") Map<String, URI> links) {
            this.disabled = disabled;
            this.reached = reached;
            this.links = ImmutableMap.copyOf(links);
        }

        public PacStatusRepresentation(boolean disabled, boolean reached, UpmUriBuilder uriBuilder, UpmLinkBuilder linkBuilder) {
            this(disabled, reached, (Map<String, URI>)linkBuilder.buildLinksFor(uriBuilder.buildPacStatusUri(), false).build());
        }

        public boolean isDisabled() {
            return this.disabled;
        }

        public boolean isReached() {
            return this.reached;
        }

        public URI getSelf() {
            return this.links.get("self");
        }
    }
}

