/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.upm.pac;

import com.atlassian.upm.core.Plugin;
import com.google.common.base.Preconditions;

public class IncompatiblePluginData {
    private String key;
    private String name;
    private String version;
    private IncompatibilityType incompatibilityType;

    IncompatiblePluginData(String key, String version, String name, IncompatibilityType incompatibilityType) {
        this.key = (String)Preconditions.checkNotNull((Object)key, (Object)"key");
        this.version = (String)Preconditions.checkNotNull((Object)version, (Object)"version");
        this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"name");
        this.incompatibilityType = (IncompatibilityType)((Object)Preconditions.checkNotNull((Object)((Object)incompatibilityType), (Object)"incompatibilityType"));
    }

    public IncompatiblePluginData(Plugin plugin, IncompatibilityType incompatibilityType) {
        this(plugin.getKey(), plugin.getVersion(), plugin.getName(), incompatibilityType);
    }

    public String getKey() {
        return this.key;
    }

    public String getVersion() {
        return this.version;
    }

    public String getName() {
        return this.name;
    }

    public IncompatibilityType getIncompatibilityType() {
        return this.incompatibilityType;
    }

    public boolean isDataCenter() {
        switch (this.incompatibilityType) {
            case DATA_CENTER: 
            case LEGACY_DATA_CENTER: {
                return true;
            }
        }
        return false;
    }

    public boolean isIncompatibleWithHostProduct() {
        switch (this.incompatibilityType) {
            case APPLICATION: 
            case APPLICATION_VERSION: {
                return true;
            }
        }
        return false;
    }

    public static enum IncompatibilityType {
        APPLICATION,
        APPLICATION_VERSION,
        DATA_CENTER,
        LEGACY_DATA_CENTER;

    }
}

