/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.upm.notification;

import com.atlassian.beehive.ClusterLock;
import com.atlassian.beehive.ClusterLockService;
import com.atlassian.sal.api.pluginsettings.PluginSettings;
import com.atlassian.sal.api.pluginsettings.PluginSettingsFactory;
import com.atlassian.sal.api.user.UserKey;
import com.atlassian.upm.api.util.Option;
import com.atlassian.upm.api.util.Pair;
import com.atlassian.upm.core.impl.NamespacedPluginSettings;
import com.atlassian.upm.impl.Locks;
import com.atlassian.upm.notification.Notification;
import com.atlassian.upm.notification.NotificationCache;
import com.atlassian.upm.notification.NotificationCollection;
import com.atlassian.upm.notification.NotificationFactory;
import com.atlassian.upm.notification.NotificationType;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class PluginSettingsNotificationCache
implements NotificationCache {
    public static final String KEY_PREFIX = "com.atlassian.upm:notifications:";
    private static final String KEY_NOTIFICATION_PREFIX = "notification-";
    private static final String KEY_DISMISSAL_PREFIX = "dismissal-";
    private final ClusterLock lock;
    private final PluginSettingsFactory pluginSettingsFactory;
    private final NotificationFactory notificationFactory;

    public PluginSettingsNotificationCache(PluginSettingsFactory pluginSettingsFactory, NotificationFactory notificationFactory, ClusterLockService lockService) {
        this.pluginSettingsFactory = (PluginSettingsFactory)Preconditions.checkNotNull((Object)pluginSettingsFactory, (Object)"pluginSettingsFactory");
        this.notificationFactory = (NotificationFactory)Preconditions.checkNotNull((Object)notificationFactory, (Object)"notificationFactory");
        this.lock = Locks.getLock((ClusterLockService)Preconditions.checkNotNull((Object)lockService, (Object)"lockService"), this.getClass());
    }

    private PluginSettings getPluginSettings() {
        return new NamespacedPluginSettings(this.pluginSettingsFactory.createGlobalSettings(), KEY_PREFIX);
    }

    @Override
    public Option<Notification> getNotification(NotificationType type, Option<UserKey> userKey, String pluginKey) {
        for (Notification notification : this.getNotifications(type, userKey, false)) {
            if (!notification.getPluginKey().equals(pluginKey)) continue;
            return Option.some(notification);
        }
        return Option.none(Notification.class);
    }

    @Override
    public Iterable<NotificationCollection> getNotifications() {
        return this.getNotifications(Option.none(UserKey.class), false);
    }

    @Override
    public Iterable<NotificationCollection> getNotifications(Option<UserKey> userKey, boolean hideDismissed) {
        return (Iterable)Locks.readWithLock(this.lock, () -> {
            ImmutableList.Builder collections = ImmutableList.builder();
            for (NotificationType type : NotificationType.values()) {
                NotificationCollection notifications = this.getNotificationsWithType(type, userKey, hideDismissed);
                if (notifications.getNotificationCount() <= 0) continue;
                collections.add((Object)notifications);
            }
            return collections.build();
        });
    }

    @Override
    public NotificationCollection getNotifications(NotificationType type, Option<UserKey> userKey, boolean hideDismissed) {
        return Locks.readWithLock(this.lock, () -> this.getNotificationsWithType(type, userKey, hideDismissed));
    }

    @Override
    public boolean isNotificationTypeDismissed(NotificationType type, Option<UserKey> userKey) {
        return Locks.readWithLock(this.lock, () -> this.getStoredNotificationDismissedValue(PluginSettingsNotificationCache.getDismissalKey(type), userKey));
    }

    @Override
    public boolean isNotificationDismissed(NotificationType type, Option<UserKey> userKey, String pluginKey) {
        return Locks.readWithLock(this.lock, () -> this.getStoredNotificationDismissedValue(PluginSettingsNotificationCache.getDismissalKey(type, Option.some(pluginKey)), userKey));
    }

    @Override
    public void setNotifications(NotificationType type, Iterable<String> pluginKeys) {
        Locks.writeWithLock(this.lock, () -> this.saveNotifications(type, pluginKeys));
    }

    @Override
    public void addNotificationForPlugin(NotificationType type, String pluginKey) {
        Locks.writeWithLock(this.lock, () -> {
            NotificationCollection previousNotifications = this.getNotificationsWithType(type, Option.none(UserKey.class), false);
            Iterable previousPluginKeys = Iterables.transform((Iterable)previousNotifications, Notification.toNotificationPluginKey());
            if (Iterables.contains((Iterable)previousPluginKeys, (Object)pluginKey)) {
                this.removeDismissalWithType(type, Option.some(pluginKey));
            } else {
                this.saveNotifications(type, Iterables.concat((Iterable)previousPluginKeys, (Iterable)ImmutableList.of((Object)pluginKey)));
            }
        });
    }

    @Override
    public void removeNotificationForPlugin(NotificationType type, String pluginKey) {
        Locks.writeWithLock(this.lock, () -> {
            NotificationCollection previousNotifications = this.getNotificationsWithType(type, Option.none(UserKey.class), false);
            Iterable previousPluginKeys = Iterables.transform((Iterable)previousNotifications, Notification.toNotificationPluginKey());
            if (Iterables.contains((Iterable)previousPluginKeys, (Object)pluginKey)) {
                this.saveNotifications(type, Iterables.filter((Iterable)previousPluginKeys, (Predicate)Predicates.not((Predicate)Predicates.equalTo((Object)pluginKey))));
            }
        });
    }

    @Override
    public void setNotificationCount(NotificationType type, int count) {
        Locks.writeWithLock(this.lock, () -> {
            NotificationCollection previousNotifications = this.getNotificationsWithType(type, Option.none(UserKey.class), false);
            this.getPluginSettings().put(PluginSettingsNotificationCache.getNotificationKey(type), (Object)String.valueOf(count));
            this.removeAllDismissalsForNotificationType(type, previousNotifications);
        });
    }

    @Override
    public void setNotificationTypeDismissal(NotificationType type, UserKey userKey, boolean dismissed) {
        Locks.writeWithLock(this.lock, () -> {
            this.dismissNotification(type, Option.none(String.class), userKey, dismissed);
            if (!type.isAlwaysDisplayedIndividually()) {
                for (Notification notification : this.getNotificationsWithType(type, Option.some(userKey), false)) {
                    this.dismissNotification(type, Option.some(notification.getPluginKey()), userKey, dismissed);
                }
            }
        });
    }

    @Override
    public void setNotificationDismissal(NotificationType type, UserKey userKey, String pluginKey, boolean dismissed) {
        Locks.writeWithLock(this.lock, () -> this.dismissNotification(type, Option.some(pluginKey), userKey, dismissed));
    }

    @Override
    public void resetNotificationTypeDismissal(NotificationType type) {
        Locks.writeWithLock(this.lock, () -> this.removeDismissalWithType(type, Option.none(String.class)));
    }

    @Override
    public void resetNotificationDismissal(NotificationType type, String pluginKey) {
        Locks.writeWithLock(this.lock, () -> this.removeDismissalWithType(type, Option.some(pluginKey)));
    }

    private NotificationCollection getNotificationsWithType(NotificationType type, Option<UserKey> userKey, boolean hideDismissed) {
        boolean typeDismissed = this.getStoredNotificationDismissedValue(PluginSettingsNotificationCache.getDismissalKey(type), userKey);
        Object storedValue = this.getPluginSettings().get(PluginSettingsNotificationCache.getNotificationKey(type));
        if (typeDismissed && hideDismissed) {
            return this.notificationFactory.getNotifications(type, (Iterable<Pair<String, Boolean>>)ImmutableList.of(), typeDismissed);
        }
        if (storedValue instanceof List) {
            Iterable pluginKeys = (Iterable)storedValue;
            if (hideDismissed) {
                pluginKeys = Iterables.filter((Iterable)pluginKeys, (Predicate)Predicates.not(this.getNotificationDismissalPredicate(type, userKey)));
            }
            Iterable pluginDismissalPairs = Iterables.transform((Iterable)pluginKeys, this.getPluginDismissalPairs(type, userKey, typeDismissed));
            return this.notificationFactory.getNotifications(type, pluginDismissalPairs, typeDismissed);
        }
        if (storedValue instanceof String) {
            try {
                int count = Integer.parseInt((String)storedValue);
                return this.notificationFactory.getNotifications(type, count, typeDismissed);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return this.notificationFactory.getNotifications(type, (Iterable<Pair<String, Boolean>>)ImmutableList.of(), typeDismissed);
    }

    private void saveNotifications(NotificationType type, Iterable<String> pluginKeys) {
        NotificationCollection previousNotifications = this.getNotificationsWithType(type, Option.none(UserKey.class), false);
        this.getPluginSettings().put(PluginSettingsNotificationCache.getNotificationKey(type), (Object)Lists.newArrayList(pluginKeys));
        Iterable previousPluginKeys = Iterables.transform((Iterable)previousNotifications, Notification.toNotificationPluginKey());
        boolean resetTypeDismissed = false;
        for (String pluginKey : pluginKeys) {
            if (Iterables.contains((Iterable)previousPluginKeys, (Object)pluginKey)) continue;
            resetTypeDismissed = true;
            break;
        }
        for (String previousPluginKey : previousPluginKeys) {
            if (Iterables.contains(pluginKeys, (Object)previousPluginKey)) continue;
            this.removeDismissalWithType(type, Option.some(previousPluginKey));
        }
        if (resetTypeDismissed) {
            this.removeAllDismissalsForNotificationType(type, previousNotifications);
        }
    }

    private boolean getStoredNotificationDismissedValue(String pluginSettingsKey, Option<UserKey> userKey) {
        Iterator<UserKey> iterator = userKey.iterator();
        if (iterator.hasNext()) {
            UserKey uk = iterator.next();
            Object storedValue = this.getPluginSettings().get(pluginSettingsKey);
            if (storedValue instanceof List) {
                return ((List)storedValue).contains(uk.getStringValue());
            }
            return false;
        }
        return false;
    }

    private void removeDismissalWithType(NotificationType type, Option<String> pluginKey) {
        this.getPluginSettings().remove(PluginSettingsNotificationCache.getDismissalKey(type, pluginKey));
    }

    private void removeAllDismissalsForNotificationType(NotificationType type, Iterable<Notification> notifications) {
        this.removeDismissalWithType(type, Option.none(String.class));
        for (Notification previousNotification : notifications) {
            this.removeDismissalWithType(type, Option.some(previousNotification.getPluginKey()));
        }
    }

    private void dismissNotification(NotificationType type, Option<String> pluginKey, UserKey userKey, boolean dismissed) {
        List<String> userKeys;
        String pluginSettingsKey = PluginSettingsNotificationCache.getDismissalKey(type, pluginKey);
        Object storedValue = this.getPluginSettings().get(pluginSettingsKey);
        List list = userKeys = storedValue == null ? new ArrayList() : (List)storedValue;
        if (dismissed && !userKeys.contains(userKey.getStringValue())) {
            userKeys.add(userKey.getStringValue());
            this.getPluginSettings().put(pluginSettingsKey, userKeys);
        } else if (!dismissed && userKeys.contains(userKey.getStringValue())) {
            userKeys.remove(userKey.getStringValue());
            if (userKeys.isEmpty()) {
                this.getPluginSettings().remove(pluginSettingsKey);
            } else {
                this.getPluginSettings().put(pluginSettingsKey, userKeys);
            }
        }
    }

    private Function<String, Pair<String, Boolean>> getPluginDismissalPairs(NotificationType type, Option<UserKey> userKey, boolean typeDismissed) {
        return new GetPluginDismissalPairs(type, userKey, typeDismissed);
    }

    private Predicate<String> getNotificationDismissalPredicate(NotificationType type, Option<UserKey> userKey) {
        return new NotificationDismissalPredicate(type, userKey);
    }

    public static String getNotificationKey(NotificationType type) {
        return KEY_NOTIFICATION_PREFIX + type.getKey();
    }

    public static String getDismissalKey(NotificationType type) {
        return PluginSettingsNotificationCache.getDismissalKey(type, Option.none(String.class));
    }

    public static String getDismissalKey(NotificationType type, Option<String> pluginKey) {
        Iterator<String> iterator = pluginKey.iterator();
        if (iterator.hasNext()) {
            String pk = iterator.next();
            return KEY_DISMISSAL_PREFIX + type.getKey() + ":" + pk;
        }
        return KEY_DISMISSAL_PREFIX + type.getKey();
    }

    private final class NotificationDismissalPredicate
    implements Predicate<String> {
        private final NotificationType type;
        private final Option<UserKey> userKey;

        NotificationDismissalPredicate(NotificationType type, Option<UserKey> userKey) {
            this.type = (NotificationType)((Object)Preconditions.checkNotNull((Object)((Object)type), (Object)"type"));
            this.userKey = (Option)Preconditions.checkNotNull(userKey, (Object)"userKey");
        }

        public boolean apply(String pluginKey) {
            return PluginSettingsNotificationCache.this.getStoredNotificationDismissedValue(PluginSettingsNotificationCache.getDismissalKey(this.type, Option.some(pluginKey)), this.userKey);
        }
    }

    private final class GetPluginDismissalPairs
    implements Function<String, Pair<String, Boolean>> {
        private final NotificationType type;
        private final Option<UserKey> userKey;
        private final boolean typeDismissed;

        GetPluginDismissalPairs(NotificationType type, Option<UserKey> userKey, boolean typeDismissed) {
            this.type = (NotificationType)((Object)Preconditions.checkNotNull((Object)((Object)type), (Object)"type"));
            this.userKey = userKey;
            this.typeDismissed = typeDismissed;
        }

        public Pair<String, Boolean> apply(String pluginKey) {
            boolean notificationDismissed = PluginSettingsNotificationCache.this.getStoredNotificationDismissedValue(PluginSettingsNotificationCache.getDismissalKey(this.type, Option.some(pluginKey)), this.userKey);
            return Pair.pair(pluginKey, notificationDismissed || this.typeDismissed);
        }
    }
}

