/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.upm.notification;

import com.atlassian.upm.api.license.entity.LicenseError;
import com.atlassian.upm.api.license.entity.PluginLicense;
import com.atlassian.upm.api.license.event.PluginLicenseEvent;
import com.atlassian.upm.api.license.event.PluginLicenseExpiredEvent;
import com.atlassian.upm.core.PluginRetriever;
import com.atlassian.upm.core.impl.UpmAppManager;
import com.atlassian.upm.license.PluginLicenses;
import com.atlassian.upm.license.internal.PluginLicenseGlobalEvent;
import com.atlassian.upm.license.internal.PluginLicenseGlobalEventPublisher;
import com.atlassian.upm.license.internal.PluginLicenseRepository;
import com.atlassian.upm.license.internal.PluginLicensesInternal;
import com.atlassian.upm.license.internal.event.PluginLicenseEventPublisherRegistry;
import com.atlassian.upm.lifecycle.UpmProductDataStartupComponent;
import com.atlassian.upm.notification.NotificationCache;
import com.atlassian.upm.notification.NotificationType;
import com.atlassian.upm.notification.PluginLicenseNotificationChecker;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.util.Set;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.springframework.beans.factory.DisposableBean;

public class PluginLicenseNotificationCheckerImpl
implements PluginLicenseNotificationChecker,
PluginLicenseGlobalEventPublisher,
UpmProductDataStartupComponent,
DisposableBean {
    private final NotificationCache cache;
    private final PluginLicenseRepository licenseRepository;
    private final PluginRetriever pluginRetriever;
    private final PluginLicenseEventPublisherRegistry registry;
    private final UpmAppManager appManager;

    public PluginLicenseNotificationCheckerImpl(NotificationCache cache, PluginLicenseRepository licenseRepository, PluginRetriever pluginRetriever, PluginLicenseEventPublisherRegistry registry, UpmAppManager appManager) {
        this.cache = (NotificationCache)Preconditions.checkNotNull((Object)cache, (Object)"cache");
        this.licenseRepository = (PluginLicenseRepository)Preconditions.checkNotNull((Object)licenseRepository, (Object)"licenseRepository");
        this.pluginRetriever = (PluginRetriever)Preconditions.checkNotNull((Object)pluginRetriever, (Object)"pluginRetriever");
        this.registry = (PluginLicenseEventPublisherRegistry)Preconditions.checkNotNull((Object)registry, (Object)"registry");
        this.appManager = (UpmAppManager)Preconditions.checkNotNull((Object)appManager, (Object)"appManager");
    }

    @Override
    public void onStartupWithProductData() {
        this.registry.registerGlobal(this);
    }

    public void destroy() throws Exception {
        this.registry.unregisterGlobal(this);
    }

    @Override
    public void publish(PluginLicenseEvent event) {
        if (!(event instanceof PluginLicenseExpiredEvent)) {
            this.updateLocalPluginLicenseNotifications();
        }
    }

    @Override
    public void publishGlobal(PluginLicenseGlobalEvent event) {
    }

    @Override
    public void updateLocalPluginLicenseNotifications() {
        Set<String> appPluginKeys = this.appManager.getApplicationRelatedPluginKeys();
        ImmutableList licenses = ImmutableList.copyOf((Iterable)Iterables.filter(this.licenseRepository.getPluginLicenses(), (Predicate)Predicates.not((Predicate)Predicates.compose((Predicate)Predicates.in(appPluginKeys), PluginLicenses.licensePluginKey()))));
        this.cache.setNotifications(NotificationType.EDITION_MISMATCH_PLUGIN_LICENSE, this.pluginKeys((Iterable<PluginLicense>)licenses, PluginLicensesInternal.isEditionMismatch()));
        this.cache.setNotifications(NotificationType.EXPIRED_EVALUATION_PLUGIN_LICENSE, this.pluginKeys((Iterable<PluginLicense>)licenses, PluginLicensesInternal.isRecentlyExpiredEvaluation(this.pluginRetriever, this.appManager)));
        this.cache.setNotifications(NotificationType.NEARLY_EXPIRED_EVALUATION_PLUGIN_LICENSE, this.pluginKeys((Iterable<PluginLicense>)licenses, PluginLicensesInternal.isNearlyExpiredEvaluation(this.pluginRetriever, this.appManager)));
        this.cache.setNotifications(NotificationType.MAINTENANCE_EXPIRED_PLUGIN_LICENSE, this.pluginKeys((Iterable<PluginLicense>)licenses, PluginLicensesInternal.isMaintenanceRecentlyExpired(this.pluginRetriever, this.appManager)));
        this.cache.setNotifications(NotificationType.MAINTENANCE_NEARLY_EXPIRED_PLUGIN_LICENSE, this.pluginKeys((Iterable<PluginLicense>)licenses, PluginLicensesInternal.isMaintenanceNearlyExpired(this.pluginRetriever, this.appManager)));
        this.cache.setNotifications(NotificationType.DATA_CENTER_EXPIRED_PLUGIN_LICENSE, this.pluginKeys((Iterable<PluginLicense>)licenses, PluginLicensesInternal.isDataCenterLicenseRecentlyExpired(this.pluginRetriever, this.appManager)));
        this.cache.setNotifications(NotificationType.DATA_CENTER_NEARLY_EXPIRED_PLUGIN_LICENSE, this.pluginKeys((Iterable<PluginLicense>)licenses, PluginLicensesInternal.isDataCenterLicenseNearlyExpired(this.pluginRetriever, this.appManager)));
        DateTime recentExpirationThreshold = new DateTime().minusDays(1);
        for (PluginLicense expiredLicense : Iterables.filter((Iterable)licenses, PluginLicenses.hasError(LicenseError.EXPIRED))) {
            for (DateTime expiryDate : expiredLicense.getExpiryDate()) {
                if (expiryDate.isBefore((ReadableInstant)recentExpirationThreshold)) continue;
                this.registry.publishEvent(new PluginLicenseExpiredEvent(expiredLicense, expiryDate));
            }
        }
    }

    private Iterable<String> pluginKeys(Iterable<PluginLicense> licenses, Predicate<PluginLicense> condition) {
        return ImmutableList.copyOf((Iterable)Iterables.transform((Iterable)Iterables.filter(licenses, condition), PluginLicensesInternal.toPluginKey()));
    }
}

